/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.peripheral;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import noki.moreturtles.MoreTurtlesData;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;

public class PeripheralDimensionalCommand
implements ITurtleCommand {
    public MTTurtleAccess turtle;
    public int dimensionID;

    public PeripheralDimensionalCommand(MTTurtleAccess turtle, int dimensionID) {
        this.turtle = turtle;
        this.dimensionID = dimensionID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TurtleCommandResult execute(ITurtleAccess givenTurtle) {
        WorldServer nextWorld;
        WorldServer currentWorld;
        int newX = 0;
        int newY = 0;
        int newZ = 0;
        IBlockState state = null;
        String className = null;
        boolean flag1 = false;
        for (int i = 0; i < 6; ++i) {
            newX = this.turtle.posX + EnumFacing.func_82600_a((int)i).func_82601_c();
            newY = this.turtle.posY + EnumFacing.func_82600_a((int)i).func_96559_d();
            newZ = this.turtle.posZ + EnumFacing.func_82600_a((int)i).func_82599_e();
            state = this.turtle.world.func_180495_p(new BlockPos(newX, newY, newZ));
            className = state.func_177230_c().getClass().getSimpleName();
            if (state.func_185904_a() != Material.field_151567_E && className.indexOf("portal") == -1 && className.indexOf("Portal") == -1) continue;
            flag1 = true;
            break;
        }
        if (!flag1) {
            return MTTurtleAccess.result(false, EFailureReason.NO_TRAVEL);
        }
        if (this.turtle.world.field_73011_w.getDimension() == this.dimensionID) {
            return MTTurtleAccess.result(false, EFailureReason.NO_TRAVEL);
        }
        MinecraftServer minecraftServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        try {
            currentWorld = minecraftServer.func_71218_a(this.turtle.world.field_73011_w.getDimension());
            nextWorld = minecraftServer.func_71218_a(this.dimensionID);
        }
        catch (Exception e) {
            return MTTurtleAccess.result(false, EFailureReason.NO_DIM);
        }
        if (currentWorld == null || nextWorld == null) {
            return MTTurtleAccess.result(false, EFailureReason.NO_DIM);
        }
        int nextWorldX = 0;
        int nextWorldY = 0;
        int nextWorldZ = 0;
        if (state.func_177230_c() == Blocks.field_150384_bq) {
            if (this.turtle.world.field_73011_w.getDimension() == 0 && this.dimensionID == 1) {
                BlockPos coords = nextWorld.func_175694_M();
                nextWorldX = coords.func_177958_n();
                nextWorldY = coords.func_177956_o() + 2;
                nextWorldZ = coords.func_177952_p();
            } else {
                if (this.turtle.world.field_73011_w.getDimension() != 1 || this.dimensionID != 0) return MTTurtleAccess.result(false, EFailureReason.NO_TRAVEL);
                BlockPos coords = nextWorld.func_175694_M();
                nextWorldX = coords.func_177958_n();
                if (nextWorld.func_180495_p(new BlockPos(nextWorldX, nextWorldY = coords.func_177956_o(), nextWorldZ = coords.func_177952_p())).func_177230_c() != Blocks.field_150350_a) {
                    return MTTurtleAccess.result(false, EFailureReason.NO_TRAVEL);
                }
            }
        } else {
            double moveFactor = currentWorld.field_73011_w.getMovementFactor() / nextWorld.field_73011_w.getMovementFactor();
            int nextWorldStartX = MathHelper.func_76128_c((double)((double)this.turtle.posX * moveFactor));
            int nextWorldStartZ = MathHelper.func_76128_c((double)((double)this.turtle.posZ * moveFactor));
            boolean flag2 = false;
            block3: for (int i = nextWorldStartX - 128; i < nextWorldStartX + 128; ++i) {
                for (int j = nextWorldStartZ - 128; j < nextWorldStartZ + 128; ++j) {
                    for (int k = nextWorld.func_72940_L() - 1; k >= 0; --k) {
                        if (nextWorld.func_180495_p(new BlockPos(i, k, j)).func_177230_c() != state.func_177230_c()) continue;
                        nextWorldX = i;
                        nextWorldZ = j;
                        nextWorldY = k;
                        while (nextWorld.func_180495_p(new BlockPos(i, k - 1, j)).func_177230_c() == state.func_177230_c()) {
                            --nextWorldY;
                            --k;
                        }
                        flag2 = true;
                        break block3;
                    }
                }
            }
            if (!flag2) {
                return MTTurtleAccess.result(false, EFailureReason.NO_TRAVEL);
            }
            boolean flag3 = false;
            int checkX = 0;
            int checkY = 0;
            int checkZ = 0;
            for (int i = 0; i < 6; ++i) {
                checkX = nextWorldX + EnumFacing.func_82600_a((int)i).func_82601_c();
                IBlockState checkState = nextWorld.func_180495_p(new BlockPos(checkX, checkY = nextWorldY + EnumFacing.func_82600_a((int)i).func_96559_d(), checkZ = nextWorldZ + EnumFacing.func_82600_a((int)i).func_82599_e()));
                if (checkState.func_177230_c() != Blocks.field_150350_a) continue;
                nextWorldX += EnumFacing.func_82600_a((int)i).func_82601_c();
                nextWorldY += EnumFacing.func_82600_a((int)i).func_96559_d();
                nextWorldZ += EnumFacing.func_82600_a((int)i).func_82599_e();
                flag3 = true;
                break;
            }
            if (!flag3) {
                return MTTurtleAccess.result(false, EFailureReason.NO_TRAVEL);
            }
        }
        if (!this.turtle.consumeFuel(MoreTurtlesData.consumedFuelLevel * 10)) {
            return MTTurtleAccess.result(false, EFailureReason.NO_FUEL);
        }
        this.turtle.teleportTo((World)nextWorld, new BlockPos(nextWorldX, nextWorldY, nextWorldZ));
        return MTTurtleAccess.result(true);
    }
}

