/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.peripheral;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import noki.moreturtles.others.HelperArgs;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;
import noki.moreturtles.turtle.peripheral.PeripheralDimensionalCommand;

public class PeripheralDimensionalHosted
implements IPeripheral {
    private MTTurtleAccess turtle;
    private TurtleSide side;

    public PeripheralDimensionalHosted(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = new MTTurtleAccess(turtle);
        this.side = side;
    }

    public String getType() {
        return "MoreTurtles";
    }

    public String[] getMethodNames() {
        return new String[]{"getName", "getDimension", "getDimensionID", "travel"};
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean equals(IPeripheral other) {
        return false;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        this.turtle.setTurtleInfo();
        switch (method) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDimension();
            }
            case 2: {
                return this.getDimensionID();
            }
            case 3: {
                return this.travel(arguments, context);
            }
        }
        return new Object[]{false, EFailureReason.UNKNOWN.getMessage()};
    }

    private Object[] getName() {
        return new Object[]{"Dimensional"};
    }

    private Object[] getDimension() {
        return new Object[]{this.turtle.world.field_73011_w.func_186058_p().func_186065_b()};
    }

    private Object[] getDimensionID() {
        return new Object[]{this.turtle.world.field_73011_w.getDimension()};
    }

    private Object[] travel(Object[] arguments, ILuaContext context) throws LuaException, InterruptedException {
        if (!HelperArgs.checkArguments(arguments, 1, new String[]{"number"})) {
            throw new LuaException(EFailureReason.LUA_WRONG_ARG.getMessage());
        }
        int dimensionID = (int)Math.round(HelperArgs.getDouble(arguments[0]));
        return this.turtle.executeCommand(context, new PeripheralDimensionalCommand(this.turtle, dimensionID));
    }
}

