/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.peripheral;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Arrays;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import noki.moreturtles.others.HelperArgs;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;

public class PeripheralLightHosted
implements IPeripheral {
    private MTTurtleAccess turtle;
    private TurtleSide side;
    private static String[] dirs = new String[]{"bottom", "top", "front", "back", "left", "right"};

    public PeripheralLightHosted(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = new MTTurtleAccess(turtle);
        this.side = side;
    }

    public String getType() {
        return "MoreTurtles";
    }

    public String[] getMethodNames() {
        return new String[]{"getName", "detectLight", "detectSkyLight", "detectSkyLightRaw", "detectBlockLight", "canSeeTheSky", "setLight"};
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean equals(IPeripheral other) {
        return false;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        this.turtle.setTurtleInfo();
        switch (method) {
            case 0: {
                return this.getName();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.detectLight(method, arguments);
            }
            case 5: {
                return this.canSeeTheSky(arguments);
            }
            case 6: {
                return this.setLight(arguments);
            }
        }
        return new Object[]{false, EFailureReason.UNKNOWN.getMessage()};
    }

    private Object[] getName() {
        return new Object[]{"Light"};
    }

    private Object[] detectLight(int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!HelperArgs.checkArguments(arguments, 1, new String[]{"string"})) {
            throw new LuaException(EFailureReason.LUA_WRONG_ARG.getMessage());
        }
        String dirName = HelperArgs.getString(arguments[0]);
        if (!Arrays.asList(dirs).contains(dirName)) {
            throw new LuaException(EFailureReason.LUA_WRONG_ARG.getMessage());
        }
        int dirNum = Arrays.asList(dirs).indexOf(dirName);
        EnumFacing dir = EnumFacing.DOWN;
        EnumFacing turtleDir = this.turtle.getDirection();
        block0 : switch (dirNum) {
            case 0: {
                dir = EnumFacing.DOWN;
                break;
            }
            case 1: {
                dir = EnumFacing.UP;
                break;
            }
            case 2: {
                dir = turtleDir;
                break;
            }
            case 3: {
                dir = turtleDir.func_176734_d();
                break;
            }
            case 4: {
                switch (turtleDir) {
                    case NORTH: {
                        dir = EnumFacing.WEST;
                        break block0;
                    }
                    case SOUTH: {
                        dir = EnumFacing.EAST;
                        break block0;
                    }
                    case EAST: {
                        dir = EnumFacing.NORTH;
                        break block0;
                    }
                    case WEST: {
                        dir = EnumFacing.SOUTH;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (turtleDir) {
                    case NORTH: {
                        dir = EnumFacing.WEST;
                        break block0;
                    }
                    case SOUTH: {
                        dir = EnumFacing.EAST;
                        break block0;
                    }
                    case EAST: {
                        dir = EnumFacing.NORTH;
                        break block0;
                    }
                    case WEST: {
                        dir = EnumFacing.SOUTH;
                        break block0;
                    }
                }
                break;
            }
            default: {
                dir = EnumFacing.DOWN;
            }
        }
        int newX = this.turtle.posX + dir.func_82601_c();
        int newY = this.turtle.posY + dir.func_96559_d();
        int newZ = this.turtle.posZ + dir.func_82599_e();
        BlockPos pos = new BlockPos(newX, newY, newZ);
        int lightLevel = 0;
        switch (method) {
            case 1: {
                lightLevel = this.turtle.world.func_175699_k(pos);
                break;
            }
            case 2: {
                lightLevel = this.turtle.world.func_175642_b(EnumSkyBlock.SKY, pos);
                if ((lightLevel -= this.turtle.world.func_175657_ab()) >= 0) break;
                lightLevel = 0;
                break;
            }
            case 3: {
                lightLevel = this.turtle.world.func_175642_b(EnumSkyBlock.SKY, pos);
                break;
            }
            case 4: {
                lightLevel = this.turtle.world.func_175642_b(EnumSkyBlock.BLOCK, pos);
            }
        }
        return new Object[]{lightLevel};
    }

    private Object[] canSeeTheSky(Object[] arguments) throws LuaException, InterruptedException {
        boolean result = this.turtle.world.func_175678_i(new BlockPos(this.turtle.posX, this.turtle.posY, this.turtle.posZ));
        return new Object[]{result};
    }

    private Object[] setLight(Object[] arguments) throws LuaException, InterruptedException {
        if (!HelperArgs.checkArguments(arguments, 1, new String[]{"number"})) {
            throw new LuaException(EFailureReason.LUA_WRONG_ARG.getMessage());
        }
        int lightLevel = (int)MathHelper.func_151237_a((double)HelperArgs.getDouble(arguments[0]), (double)0.0, (double)15.0);
        this.turtle.world.func_175653_a(EnumSkyBlock.BLOCK, this.turtle.getPosition(), lightLevel);
        this.turtle.world.func_175704_b(this.turtle.getPosition().func_177982_a(-15, -15, -15), this.turtle.getPosition().func_177982_a(15, 15, 15));
        return new Object[]{true};
    }
}

