/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.peripheral;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import noki.moreturtles.MoreTurtlesData;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;

public class PeripheralLootingCommand
implements ITurtleCommand {
    private TurtleSide side;
    private EnumFacing dir;
    private static int[] yaw = new int[]{0, 0, 180, 0, 90, -90};
    private static int[] pitch = new int[]{90, -90, 0, 0, 0, 0};
    private static String[] allowedTool = new String[]{MoreTurtlesData.cc_Sword};

    public PeripheralLootingCommand(TurtleSide side, EnumFacing dir) {
        this.side = side;
        this.dir = dir;
    }

    public TurtleCommandResult execute(ITurtleAccess givenTurtle) {
        MTTurtleAccess turtle = new MTTurtleAccess(givenTurtle);
        if (!this.checkTool(turtle, this.side)) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ATTACK_TOOL);
        }
        turtle.setTurtleInfo();
        turtle.playerTurtle.field_70165_t += 0.5;
        turtle.playerTurtle.field_70163_u += 0.5;
        turtle.playerTurtle.field_70161_v += 0.5;
        turtle.playerTurtle.field_70177_z = yaw[this.dir.func_176745_a()];
        turtle.playerTurtle.field_70125_A = pitch[this.dir.func_176745_a()];
        Vec3d turtlePos = new Vec3d(turtle.playerTurtle.field_70165_t, turtle.playerTurtle.field_70163_u, turtle.playerTurtle.field_70161_v);
        Vec3d rayDir = turtle.playerTurtle.func_70676_i(1.0f);
        Vec3d rayStart = turtlePos.func_72441_c(rayDir.field_72450_a * 0.4, rayDir.field_72448_b * 0.4, rayDir.field_72449_c * 0.4);
        EntityLivingBase hitEntity = this.getNearestLivingEntity(turtle.world, rayStart, rayDir, 1.1);
        if (hitEntity != null) {
            if (!turtle.consumeFuel(MoreTurtlesData.consumedFuelLevel)) {
                return MTTurtleAccess.result(false, EFailureReason.NO_FUEL);
            }
            HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
            map.put(Enchantment.func_180305_b((String)"looting"), 3);
            ItemStack stack = new ItemStack(Items.field_151048_u);
            EnchantmentHelper.func_82782_a(map, (ItemStack)stack);
            turtle.setCurrentItem(stack);
            float damage = (float)turtle.playerTurtle.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            damage *= 9.0f;
            boolean flag = false;
            if (damage > 0.0f) {
                flag = hitEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)turtle.playerTurtle), damage);
            }
            if (flag) {
                if (hitEntity.func_110143_aJ() <= 0.0f) {
                    for (EntityItem each : hitEntity.capturedDrops) {
                        turtle.store(each.func_92059_d());
                    }
                }
                return MTTurtleAccess.result(true);
            }
        }
        return MTTurtleAccess.result(false, EFailureReason.NO_ATTACK_TARGET);
    }

    private EntityLivingBase getNearestLivingEntity(World world, Vec3d vecStart, Vec3d vecDir, double distance) {
        Vec3d vecEnd = vecStart.func_72441_c(vecDir.field_72450_a * distance, vecDir.field_72448_b * distance, vecDir.field_72449_c * distance);
        RayTraceResult result = world.func_72933_a(vecStart.func_72441_c(0.0, 0.0, 0.0), vecEnd.func_72441_c(0.0, 0.0, 0.0));
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            distance = vecStart.func_72438_d(result.field_72307_f);
            vecEnd = vecStart.func_72441_c(vecDir.field_72450_a * distance, vecDir.field_72448_b * distance, vecDir.field_72449_c * distance);
        }
        float xStretch = Math.abs(vecDir.field_72450_a) > 0.25 ? 0.0f : 1.0f;
        float yStretch = Math.abs(vecDir.field_72448_b) > 0.25 ? 0.0f : 1.0f;
        float zStretch = Math.abs(vecDir.field_72449_c) > 0.25 ? 0.0f : 1.0f;
        AxisAlignedBB rangeBox = new AxisAlignedBB(Math.min(vecStart.field_72450_a, vecEnd.field_72450_a) - (double)(0.375f * xStretch), Math.min(vecStart.field_72448_b, vecEnd.field_72448_b) - (double)(0.375f * yStretch), Math.min(vecStart.field_72449_c, vecEnd.field_72449_c) - (double)(0.375f * zStretch), Math.max(vecStart.field_72450_a, vecEnd.field_72450_a) + (double)(0.375f * xStretch), Math.max(vecStart.field_72448_b, vecEnd.field_72448_b) + (double)(0.375f * yStretch), Math.max(vecStart.field_72449_c, vecEnd.field_72449_c) + (double)(0.375f * zStretch));
        EntityLivingBase closest = null;
        double closestDist = 99.0;
        List list = world.func_72839_b(null, rangeBox);
        for (Object target : list) {
            EntityLivingBase entity;
            if (target instanceof EntityPlayer || !(target instanceof EntityLivingBase) || !(entity = (EntityLivingBase)target).func_70089_S()) continue;
            AxisAlignedBB entityBox = entity.func_174813_aQ();
            if (entityBox.func_72318_a(vecStart)) {
                closest = entity;
                closestDist = 0.0;
                break;
            }
            Vec3d vecEntity = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(vecStart.func_72438_d(vecEntity) < closestDist)) continue;
            closest = entity;
            closestDist = vecStart.func_72438_d(vecEntity);
        }
        if (closest != null) {
            return closest;
        }
        return null;
    }

    private boolean checkTool(MTTurtleAccess turtle, TurtleSide side) {
        if (turtle.getOtherUpgrade(side) == null) {
            return false;
        }
        return Arrays.asList(allowedTool).contains(turtle.getOtherUpgradeName(side));
    }
}

