/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.peripheral;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import java.lang.reflect.Method;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;

public class PeripheralProjectileCommand
implements ITurtleCommand {
    MTTurtleAccess turtle;
    boolean setCharge;
    float charge = 0.0f;

    public PeripheralProjectileCommand(MTTurtleAccess turtle, boolean setCharge, float charge) {
        this.turtle = turtle;
        this.setCharge = setCharge;
        this.charge = charge;
    }

    public TurtleCommandResult execute(ITurtleAccess givenTurtle) {
        float charge;
        int currentSlot = this.turtle.getSelectedSlot();
        ItemStack currentStack = this.turtle.getSlotContents(currentSlot);
        if (currentStack == null) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ITEM);
        }
        if (!BlockDispenser.field_149943_a.func_148741_d((Object)currentStack.func_77973_b())) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ITEM);
        }
        IBehaviorDispenseItem tmpItem = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)currentStack.func_77973_b());
        if (!(tmpItem instanceof BehaviorProjectileDispense)) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ITEM);
        }
        double x = (double)(this.turtle.posX + this.turtle.getDirection().func_82601_c()) + 0.5;
        double y = (double)(this.turtle.posY + this.turtle.getDirection().func_96559_d()) + 0.5;
        double z = (double)(this.turtle.posZ + this.turtle.getDirection().func_82599_e()) + 0.5;
        BehaviorProjectileDispense item = (BehaviorProjectileDispense)tmpItem;
        Method method1 = null;
        Entity entity = null;
        try {
            method1 = ReflectionHelper.findMethod(BehaviorProjectileDispense.class, (String)"getProjectileEntity", (String)"func_82499_a", (Class[])new Class[]{World.class, IPosition.class, ItemStack.class});
            entity = (Entity)method1.invoke((Object)item, this.turtle.world, new ShootPosition(x, y, z), currentStack);
        }
        catch (Exception e) {
            return MTTurtleAccess.result(false, EFailureReason.JAVA);
        }
        if (method1 == null || entity == null) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ITEM);
        }
        entity.field_70159_w = -MathHelper.func_76126_a((float)(this.turtle.playerTurtle.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.turtle.playerTurtle.field_70125_A / 180.0f * (float)Math.PI));
        entity.field_70179_y = MathHelper.func_76134_b((float)(this.turtle.playerTurtle.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.turtle.playerTurtle.field_70125_A / 180.0f * (float)Math.PI));
        entity.field_70181_x = -MathHelper.func_76126_a((float)(this.turtle.playerTurtle.field_70125_A / 180.0f * (float)Math.PI));
        if (this.setCharge) {
            charge = this.charge * 2.0f;
        } else {
            Method method2 = null;
            try {
                method2 = ReflectionHelper.findMethod(BehaviorProjectileDispense.class, (String)"getProjectileVelocity", (String)"func_82498_a", (Class[])new Class[0]);
                charge = ((Float)method2.invoke((Object)item, new Object[0])).floatValue();
            }
            catch (Exception e) {
                return MTTurtleAccess.result(false, EFailureReason.JAVA);
            }
        }
        ((IProjectile)entity).func_70186_c(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y, charge * 1.5f, 1.0f);
        this.turtle.world.func_72838_d(entity);
        Method method3 = null;
        try {
            method3 = ReflectionHelper.findMethod(BehaviorProjectileDispense.class, (String)"playDispenseSound", (String)"func_82485_a", (Class[])new Class[]{IBlockSource.class});
            method3.invoke((Object)item, new ShootSource(this.turtle));
        }
        catch (Exception exception) {
            // empty catch block
        }
        currentStack.func_190920_e(currentStack.func_190916_E() - 1);
        if (currentStack.func_190916_E() == 0) {
            this.turtle.setSlotContents(currentSlot, null);
        }
        return MTTurtleAccess.result(true);
    }

    private class ShootSource
    implements IBlockSource {
        private MTTurtleAccess turtle;

        public ShootSource(MTTurtleAccess turtle) {
            this.turtle = turtle;
        }

        public World func_82618_k() {
            return this.turtle.world;
        }

        public double func_82615_a() {
            return (double)this.turtle.posX + 0.5;
        }

        public double func_82617_b() {
            return (double)this.turtle.posY + 0.5;
        }

        public double func_82616_c() {
            return (double)this.turtle.posZ + 0.5;
        }

        public TileEntity func_150835_j() {
            return null;
        }

        public BlockPos func_180699_d() {
            return new BlockPos(this.turtle.posX, this.turtle.posY, this.turtle.posZ);
        }

        public IBlockState func_189992_e() {
            return null;
        }
    }

    private class ShootPosition
    implements IPosition {
        private double x;
        private double y;
        private double z;

        public ShootPosition(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double func_82615_a() {
            return this.x;
        }

        public double func_82617_b() {
            return this.y;
        }

        public double func_82616_c() {
            return this.z;
        }
    }
}

