/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.peripheral;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import net.minecraft.util.math.MathHelper;
import noki.moreturtles.others.HelperArgs;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;
import noki.moreturtles.turtle.peripheral.PeripheralProjectileCommand;

public class PeripheralProjectileHosted
implements IPeripheral {
    private MTTurtleAccess turtle;
    private TurtleSide side;
    private int dir = 0;
    private float yaw = 0.0f;
    private float pitch = 0.0f;
    private boolean setCharge = false;
    private float charge;
    private final int[] dirSet = new int[]{0, 2, 3, 1};

    public PeripheralProjectileHosted(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = new MTTurtleAccess(turtle);
        this.side = side;
    }

    public String getType() {
        return "MoreTurtles";
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean equals(IPeripheral other) {
        return false;
    }

    public String[] getMethodNames() {
        return new String[]{"getName", "shoot", "setAngle", "setCharge", "unsetCharge"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        this.turtle.setTurtleInfo();
        this.dir = this.dirSet[this.turtle.getDirection().func_176745_a() - 2];
        this.applyAngle();
        switch (method) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.shoot(context);
            }
            case 2: {
                return this.setAngle(arguments);
            }
            case 3: {
                return this.setCharge(arguments);
            }
            case 4: {
                return this.unsetCharge();
            }
        }
        return new Object[]{false, EFailureReason.UNKNOWN.getMessage()};
    }

    private Object[] getName() {
        return new Object[]{"Projetile"};
    }

    private Object[] shoot(ILuaContext context) throws LuaException, InterruptedException {
        return this.turtle.executeCommand(context, new PeripheralProjectileCommand(this.turtle, this.setCharge, this.charge));
    }

    private Object[] setCharge(Object[] arguments) throws LuaException {
        if (!HelperArgs.checkArguments(arguments, 1, new String[]{"number"})) {
            throw new LuaException(EFailureReason.LUA_WRONG_ARG.getMessage());
        }
        float charge = HelperArgs.getDouble(arguments[0]).floatValue();
        if (charge < 0.0f || 1.0f < charge) {
            throw new LuaException(EFailureReason.LUA_WRONG_ARG.getMessage());
        }
        this.setCharge = true;
        this.charge = charge;
        return new Object[]{null};
    }

    private Object[] unsetCharge() throws LuaException {
        this.setCharge = false;
        this.charge = 0.0f;
        return new Object[]{null};
    }

    private Object[] setAngle(Object[] arguments) throws LuaException {
        if (!HelperArgs.checkArguments(arguments, 2, new String[]{"number", "number"})) {
            throw new LuaException(EFailureReason.LUA_WRONG_ARG.getMessage());
        }
        this.yaw = MathHelper.func_76131_a((float)HelperArgs.getDouble(arguments[0]).floatValue(), (float)-90.0f, (float)90.0f);
        this.pitch = MathHelper.func_76131_a((float)HelperArgs.getDouble(arguments[1]).floatValue(), (float)-90.0f, (float)90.0f);
        return new Object[]{null};
    }

    private void applyAngle() {
        this.turtle.playerTurtle.field_70177_z = MathHelper.func_76142_g((float)(this.yaw + (float)((this.dir - 2) * 90)));
        this.turtle.playerTurtle.field_70125_A = this.pitch;
    }
}

