/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.peripheral;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import noki.moreturtles.MoreTurtlesData;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;

public class PeripheralSilkTouchCommand
implements ITurtleCommand {
    private TurtleSide side;
    private EnumFacing dir;
    private static String[] allowedTool = new String[]{MoreTurtlesData.cc_Axe, MoreTurtlesData.cc_Hoe, MoreTurtlesData.cc_Pickaxe, MoreTurtlesData.cc_Shovel, "Shearing", "Tofu"};

    public PeripheralSilkTouchCommand(TurtleSide side, EnumFacing dir) {
        this.side = side;
        this.dir = dir;
    }

    public TurtleCommandResult execute(ITurtleAccess givenTurtle) {
        MTTurtleAccess turtle = new MTTurtleAccess(givenTurtle);
        if (!this.checkTool(turtle, this.side)) {
            return MTTurtleAccess.result(false, EFailureReason.NO_DIG_TOOL);
        }
        int newX = turtle.posX + this.dir.func_82601_c();
        int newY = turtle.posY + this.dir.func_96559_d();
        int newZ = turtle.posZ + this.dir.func_82599_e();
        BlockPos pos = new BlockPos(newX, newY, newZ);
        IBlockState state = turtle.world.func_180495_p(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        ItemStack item = turtle.getOtherUpgradeItem(this.side);
        String currentUpgradeName = turtle.getOtherUpgradeName(this.side);
        if (turtle.world.func_175623_d(pos)) {
            return MTTurtleAccess.result(false, EFailureReason.NO_DIG_TARGET);
        }
        if (state.func_185887_b(turtle.world, pos) <= -1.0f) {
            return MTTurtleAccess.result(false, EFailureReason.NO_DIG_TARGET);
        }
        if (currentUpgradeName == "Tofu") {
            return MTTurtleAccess.result(true);
        }
        if (currentUpgradeName == "Shearing") {
            item = new ItemStack((Item)Items.field_151097_aZ);
            if (!(state.func_177230_c() instanceof IShearable) && item.func_150997_a(state) <= 1.0f) {
                return MTTurtleAccess.result(false, EFailureReason.NO_DIG_TARGET);
            }
        }
        if (!turtle.consumeFuel(MoreTurtlesData.consumedFuelLevel)) {
            return MTTurtleAccess.result(false, EFailureReason.NO_FUEL);
        }
        if (turtle.canTurtleHarvest(item, state.func_177230_c(), pos)) {
            if (state.func_177230_c().canSilkHarvest(turtle.world, pos, state, turtle.playerTurtle)) {
                ItemStack droppedItem = new ItemStack(state.func_177230_c(), 1, metadata);
                if (droppedItem != null) {
                    turtle.store(droppedItem);
                }
            } else if (currentUpgradeName == "Shearing" && state.func_177230_c() instanceof IShearable) {
                List items = ((IShearable)state.func_177230_c()).onSheared(item, (IBlockAccess)turtle.world, pos, 0);
                if (items != null) {
                    for (ItemStack each : items) {
                        turtle.store(each);
                    }
                }
            } else {
                List items = state.func_177230_c().getDrops((IBlockAccess)turtle.world, pos, state, 0);
                if (items != null) {
                    for (ItemStack each : items) {
                        turtle.store(each);
                    }
                }
            }
        }
        turtle.playAnimation(MTTurtleAccess.getOtherSwingAnimation(this.side));
        turtle.world.func_175698_g(pos);
        turtle.world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        return MTTurtleAccess.result(true);
    }

    public boolean checkTool(MTTurtleAccess turtle, TurtleSide side) {
        if (turtle.getOtherUpgrade(this.side) == null) {
            return false;
        }
        return Arrays.asList(allowedTool).contains(turtle.getOtherUpgradeName(this.side));
    }
}

