/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.tool;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noki.moreturtles.MoreTurtlesData;
import noki.moreturtles.items.ItemExtendedItems;
import noki.moreturtles.items.RegisterItems;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;
import org.apache.commons.lang3.tuple.Pair;

public class ToolFeeding
implements ITurtleUpgrade {
    private int upgradeMeta = 3;
    private ItemStack upgradeItem = new ItemStack(RegisterItems.extendedItems, 1, this.upgradeMeta);

    public ResourceLocation getUpgradeID() {
        return new ResourceLocation("moreturtles:feeding_turtle");
    }

    public int getLegacyUpgradeID() {
        return MoreTurtlesData.feedingTurtleTID;
    }

    public String getUnlocalisedAdjective() {
        return "Feeding";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        return this.upgradeItem;
    }

    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, TurtleSide side) {
        float xOffset = side == TurtleSide.Left ? -0.40625f : 0.40625f;
        Matrix4f transform = new Matrix4f(0.0f, 0.0f, -1.0f, 1.0f + xOffset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        return Pair.of((Object)mc.func_175599_af().func_175037_a().func_178089_a(new ItemStack(((ItemExtendedItems)this.upgradeItem.func_77973_b()).getEachExtendedItem(this.upgradeMeta))), (Object)transform);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, EnumFacing direction) {
        MTTurtleAccess turtleAccess = new MTTurtleAccess(turtle);
        switch (verb) {
            case Dig: {
                return this.dig(turtleAccess, direction);
            }
            case Attack: {
                return this.attack(turtleAccess, direction);
            }
        }
        return MTTurtleAccess.result(false, EFailureReason.UNKNOWN);
    }

    private TurtleCommandResult dig(MTTurtleAccess turtle, EnumFacing dir) {
        return MTTurtleAccess.result(false, EFailureReason.NO_DIG);
    }

    private TurtleCommandResult attack(MTTurtleAccess turtle, EnumFacing dir) {
        int newZ;
        int newY;
        int newX = turtle.posX + dir.func_82601_c();
        AxisAlignedBB aabb = new AxisAlignedBB((double)newX, (double)(newY = turtle.posY + dir.func_96559_d()), (double)(newZ = turtle.posZ + dir.func_82599_e()), (double)newX + 1.0, (double)newY + 1.0, (double)newZ + 1.0);
        List list = turtle.world.func_72839_b((Entity)turtle.playerTurtle, aabb);
        if (list == null || list.size() == 0) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ATTACK_TARGET);
        }
        int currentSlot = turtle.getSelectedSlot();
        ItemStack currentItem = turtle.getSlotContents(currentSlot);
        if (currentItem == null) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ITEM);
        }
        for (Object each : list) {
            EntityAnimal target;
            if (each == null || !(each instanceof EntityAnimal) || !(target = (EntityAnimal)each).func_70877_b(currentItem) || target.func_70874_b() != 0 || target.func_70880_s()) continue;
            turtle.consume(currentSlot);
            target.func_146082_f(turtle.playerTurtle);
            return MTTurtleAccess.result(true);
        }
        return MTTurtleAccess.result(false, EFailureReason.NO_ITEM);
    }
}

