/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.tool;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.HashMap;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import noki.moreturtles.MoreTurtlesData;
import noki.moreturtles.items.ItemExtendedItems;
import noki.moreturtles.items.RegisterItems;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;
import org.apache.commons.lang3.tuple.Pair;

public class ToolFishery
implements ITurtleUpgrade {
    private int upgradeMeta = 5;
    private ItemStack upgradeItem = new ItemStack(RegisterItems.extendedItems, 1, this.upgradeMeta);
    private int luckLevel = 0;
    private int addedFuelLevel = 0;
    private HashMap<BlockPos, FisheryInfo> infoList = new HashMap();

    public ResourceLocation getUpgradeID() {
        return new ResourceLocation("moreturtles:fishery_turtle");
    }

    public int getLegacyUpgradeID() {
        return MoreTurtlesData.fisheryTurtleTID;
    }

    public String getUnlocalisedAdjective() {
        return "Fishery";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        return this.upgradeItem;
    }

    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, TurtleSide side) {
        float xOffset = side == TurtleSide.Left ? -0.40625f : 0.40625f;
        Matrix4f transform = new Matrix4f(0.0f, 0.0f, -1.0f, 1.0f + xOffset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        return Pair.of((Object)mc.func_175599_af().func_175037_a().func_178089_a(new ItemStack(((ItemExtendedItems)this.upgradeItem.func_77973_b()).getEachExtendedItem(this.upgradeMeta))), (Object)transform);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, EnumFacing direction) {
        MTTurtleAccess turtleAccess = new MTTurtleAccess(turtle);
        switch (verb) {
            case Dig: {
                return this.dig(turtleAccess, direction);
            }
            case Attack: {
                return this.attack(turtleAccess, direction);
            }
        }
        return MTTurtleAccess.result(false, EFailureReason.UNKNOWN);
    }

    private TurtleCommandResult dig(MTTurtleAccess turtle, EnumFacing dir) {
        int newZ;
        int newY;
        FisheryInfo info = this.infoList.get(turtle.getPosition());
        if (info == null) {
            info = new FisheryInfo(false, null, 0L);
            this.infoList.put(turtle.getPosition(), info);
        }
        if (!info.start) {
            info.direction = null;
            info.startTime = 0L;
            return MTTurtleAccess.result(false, EFailureReason.NO_CAST);
        }
        info.start = false;
        if (info.direction != null && info.direction != dir) {
            info.direction = null;
            info.startTime = 0L;
            return MTTurtleAccess.result(false, EFailureReason.WRONG_DIR);
        }
        info.direction = null;
        int newX = turtle.posX + dir.func_82601_c();
        if (this.checkWater(turtle.world, newX, newY = turtle.posY + dir.func_96559_d(), newZ = turtle.posZ + dir.func_82599_e()) == 0) {
            info.startTime = 0L;
            return MTTurtleAccess.result(false, EFailureReason.NO_WATER);
        }
        int waterCount = 0;
        for (int i = turtle.posX - 4; i <= turtle.posX + 4; ++i) {
            for (int j = turtle.posY - 4; j <= turtle.posY + 4; ++j) {
                for (int k = turtle.posZ - 4; k <= turtle.posZ + 4; ++k) {
                    waterCount += this.checkWater(turtle.world, i, j, k);
                }
            }
        }
        double waterValue = waterCount / 728;
        long currentTime = turtle.world.func_82737_E();
        long passedTime = currentTime - info.startTime;
        info.startTime = 0L;
        if (passedTime == 0L) {
            return MTTurtleAccess.result(false, EFailureReason.NO_FISH);
        }
        double timeValue = passedTime / 400L;
        double totalValue = waterValue + timeValue;
        double targetProv = Math.abs(turtle.world.field_73012_v.nextGaussian());
        if (targetProv <= totalValue) {
            if (!turtle.consumeFuel(MoreTurtlesData.consumedFuelLevel + this.addedFuelLevel)) {
                return MTTurtleAccess.result(false, EFailureReason.NO_FUEL);
            }
            LootContext.Builder builder = new LootContext.Builder((WorldServer)turtle.world);
            builder.func_186469_a((float)(this.luckLevel + 0));
            LootTable table = turtle.world.func_184146_ak().func_186521_a(LootTableList.field_186387_al);
            for (ItemStack itemstack : table.func_186462_a(turtle.world.field_73012_v, builder.func_186471_a())) {
                turtle.store(itemstack);
            }
            return MTTurtleAccess.result(true);
        }
        return MTTurtleAccess.result(false, EFailureReason.NO_FISH);
    }

    private TurtleCommandResult attack(MTTurtleAccess turtle, EnumFacing dir) {
        int newZ;
        int newY;
        int newX;
        FisheryInfo info = this.infoList.get(turtle.getPosition());
        if (info == null) {
            info = new FisheryInfo(false, null, 0L);
            this.infoList.put(turtle.getPosition(), info);
        }
        if (this.checkWater(turtle.world, newX = turtle.posX + dir.func_82601_c(), newY = turtle.posY + dir.func_96559_d(), newZ = turtle.posZ + dir.func_82599_e()) == 0) {
            return MTTurtleAccess.result(false, EFailureReason.NO_WATER);
        }
        info.start = true;
        info.direction = dir;
        info.startTime = turtle.world.func_82737_E();
        return MTTurtleAccess.result(true);
    }

    private int checkWater(World world, int x, int y, int z) {
        IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
        if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) {
            return 1;
        }
        return 0;
    }

    public void setLuckLevel(int level) {
        this.luckLevel = level;
    }

    public void setAddedFuelLevel(int level) {
        this.addedFuelLevel = level;
    }

    private class FisheryInfo {
        public boolean start = false;
        public EnumFacing direction = null;
        public long startTime;

        public FisheryInfo(boolean start, EnumFacing direction, long startTime) {
            this.start = start;
            this.direction = direction;
            this.startTime = startTime;
        }
    }
}

