/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.tool;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import noki.moreturtles.MoreTurtlesData;
import noki.moreturtles.items.ItemExtendedItems;
import noki.moreturtles.items.RegisterItems;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;
import org.apache.commons.lang3.tuple.Pair;

public class ToolLiquid
implements ITurtleUpgrade {
    public int upgradeMeta = 1;
    public ItemStack upgradeItem = new ItemStack(RegisterItems.extendedItems, 1, this.upgradeMeta);

    public ResourceLocation getUpgradeID() {
        return new ResourceLocation("moreturtles:liquid_turtle");
    }

    public int getLegacyUpgradeID() {
        return MoreTurtlesData.liquidTurtleTID;
    }

    public String getUnlocalisedAdjective() {
        return "Liquid";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        return this.upgradeItem;
    }

    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, TurtleSide side) {
        float xOffset = side == TurtleSide.Left ? -0.40625f : 0.40625f;
        Matrix4f transform = new Matrix4f(0.0f, 0.0f, -1.0f, 1.0f + xOffset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        return Pair.of((Object)mc.func_175599_af().func_175037_a().func_178089_a(new ItemStack(((ItemExtendedItems)this.upgradeItem.func_77973_b()).getEachExtendedItem(this.upgradeMeta))), (Object)transform);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, EnumFacing direction) {
        MTTurtleAccess turtleAccess = new MTTurtleAccess(turtle);
        switch (verb) {
            case Dig: {
                return this.dig(turtleAccess, direction);
            }
            case Attack: {
                return this.attack(turtleAccess, direction);
            }
        }
        return MTTurtleAccess.result(false, EFailureReason.UNKNOWN);
    }

    private TurtleCommandResult dig(MTTurtleAccess turtle, EnumFacing dir) {
        FluidActionResult result;
        int newX = turtle.posX + dir.func_82601_c();
        int newY = turtle.posY + dir.func_96559_d();
        int newZ = turtle.posZ + dir.func_82599_e();
        BlockPos pos = new BlockPos(newX, newY, newZ);
        IBlockState state = turtle.world.func_180495_p(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        int currentSlot = turtle.getSelectedSlot();
        ItemStack currentItem = turtle.getSlotContents(currentSlot);
        if (currentItem == null) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ITEM);
        }
        if (FluidUtil.getFluidHandler((ItemStack)currentItem) != null && (result = FluidUtil.tryPickUpFluid((ItemStack)currentItem, null, (World)turtle.world, (BlockPos)pos, null)).isSuccess()) {
            turtle.consume(currentSlot);
            turtle.store(result.result);
            return MTTurtleAccess.result(true);
        }
        if ((state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) && metadata == 0 && currentItem.func_77973_b() == Items.field_151069_bo) {
            turtle.consume(currentSlot);
            turtle.store(new ItemStack((Item)Items.field_151068_bn, 1, 0));
            return MTTurtleAccess.result(true);
        }
        if (state.func_177230_c() == Blocks.field_150383_bp && currentItem.func_77973_b() == Items.field_151069_bo && metadata > 0) {
            turtle.world.func_175656_a(pos, state.func_177230_c().func_176203_a(metadata - 1));
            turtle.consume(currentSlot);
            turtle.store(new ItemStack((Item)Items.field_151068_bn, 1, 0));
            return MTTurtleAccess.result(true);
        }
        return MTTurtleAccess.result(false, EFailureReason.NO_DIG_TARGET);
    }

    private TurtleCommandResult attack(MTTurtleAccess turtle, EnumFacing dir) {
        FluidActionResult result;
        int newX = turtle.posX + dir.func_82601_c();
        int newY = turtle.posY + dir.func_96559_d();
        int newZ = turtle.posZ + dir.func_82599_e();
        BlockPos pos = new BlockPos(newX, newY, newZ);
        IBlockState state = turtle.world.func_180495_p(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        int currentSlot = turtle.getSelectedSlot();
        ItemStack currentItem = turtle.getSlotContents(currentSlot);
        if (currentItem == null) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ITEM);
        }
        if (FluidUtil.getFluidHandler((ItemStack)currentItem) != null && (result = FluidUtil.tryPlaceFluid(null, (World)turtle.world, (BlockPos)pos, (ItemStack)currentItem, (FluidStack)FluidUtil.getFluidContained((ItemStack)currentItem))).isSuccess()) {
            turtle.consume(currentSlot);
            turtle.store(result.result);
            return MTTurtleAccess.result(true);
        }
        if (state.func_177230_c() == Blocks.field_150383_bp && currentItem.func_77973_b() == Items.field_151131_as && metadata < 3) {
            turtle.consume(currentSlot);
            turtle.store(new ItemStack(Items.field_151133_ar));
            turtle.world.func_175656_a(pos, state.func_177230_c().func_176203_a(3));
            return MTTurtleAccess.result(true);
        }
        return MTTurtleAccess.result(false, EFailureReason.NO_ATTACK_TARGET);
    }
}

