/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.tool;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import noki.moreturtles.MoreTurtlesData;
import noki.moreturtles.items.ItemExtendedItems;
import noki.moreturtles.items.RegisterItems;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;
import org.apache.commons.lang3.tuple.Pair;

public class ToolShearing
implements ITurtleUpgrade {
    public int upgradeMeta = 2;
    public ItemStack upgradeItem = new ItemStack(RegisterItems.extendedItems, 1, this.upgradeMeta);

    public ResourceLocation getUpgradeID() {
        return new ResourceLocation("moreturtles:shearing_turtle");
    }

    public int getLegacyUpgradeID() {
        return MoreTurtlesData.shearsTurtleTID;
    }

    public String getUnlocalisedAdjective() {
        return "Shearing";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        return this.upgradeItem;
    }

    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, TurtleSide side) {
        float xOffset = side == TurtleSide.Left ? -0.40625f : 0.40625f;
        Matrix4f transform = new Matrix4f(0.0f, 0.0f, -1.0f, 1.0f + xOffset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        return Pair.of((Object)mc.func_175599_af().func_175037_a().func_178089_a(new ItemStack(((ItemExtendedItems)this.upgradeItem.func_77973_b()).getEachExtendedItem(this.upgradeMeta))), (Object)transform);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, EnumFacing direction) {
        MTTurtleAccess turtleAccess = new MTTurtleAccess(turtle);
        switch (verb) {
            case Dig: {
                return this.dig(turtleAccess, direction);
            }
            case Attack: {
                return this.attack(turtleAccess, direction);
            }
        }
        return MTTurtleAccess.result(false, EFailureReason.UNKNOWN);
    }

    private TurtleCommandResult dig(MTTurtleAccess turtle, EnumFacing dir) {
        int newX = turtle.posX + dir.func_82601_c();
        int newY = turtle.posY + dir.func_96559_d();
        int newZ = turtle.posZ + dir.func_82599_e();
        BlockPos pos = new BlockPos(newX, newY, newZ);
        IBlockState state = turtle.world.func_180495_p(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        ItemStack item = new ItemStack((Item)Items.field_151097_aZ);
        if (turtle.world.func_175623_d(pos)) {
            return MTTurtleAccess.result(false, EFailureReason.NO_DIG_TARGET);
        }
        if (state.func_185887_b(turtle.world, pos) <= -1.0f) {
            return MTTurtleAccess.result(false, EFailureReason.NO_DIG_TARGET);
        }
        if (!(state.func_177230_c() instanceof IShearable) && item.func_150997_a(state) <= 1.0f) {
            return MTTurtleAccess.result(false, EFailureReason.NO_DIG_TARGET);
        }
        List items = state.func_177230_c() instanceof IShearable ? ((IShearable)state.func_177230_c()).onSheared(item, (IBlockAccess)turtle.world, pos, 0) : state.func_177230_c().getDrops((IBlockAccess)turtle.world, pos, state, 0);
        turtle.world.func_175698_g(pos);
        turtle.world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        if (items != null) {
            for (ItemStack each : items) {
                turtle.store(each);
            }
        }
        return MTTurtleAccess.result(true);
    }

    private TurtleCommandResult attack(MTTurtleAccess turtle, EnumFacing dir) {
        int newZ;
        int newY;
        int newX = turtle.posX + dir.func_82601_c();
        AxisAlignedBB aabb = new AxisAlignedBB((double)newX, (double)(newY = turtle.posY + dir.func_96559_d()), (double)(newZ = turtle.posZ + dir.func_82599_e()), (double)newX + 1.0, (double)newY + 1.0, (double)newZ + 1.0);
        List list = turtle.world.func_72839_b((Entity)turtle.playerTurtle, aabb);
        if (list == null || list.size() == 0) {
            return MTTurtleAccess.result(false, EFailureReason.NO_ATTACK_TARGET);
        }
        for (Object each : list) {
            ItemStack shears;
            Entity entity;
            if (each == null || !(each instanceof IShearable) || !((IShearable)(entity = (Entity)each)).isShearable(shears = new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)entity.field_70170_p, new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v))) continue;
            List ret = ((IShearable)entity).onSheared(shears, (IBlockAccess)entity.field_70170_p, new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v), 0);
            if (ret != null) {
                for (ItemStack item : ret) {
                    turtle.store(item);
                }
            }
            return MTTurtleAccess.result(true);
        }
        return MTTurtleAccess.result(false, EFailureReason.NO_ATTACK_TARGET);
    }
}

