/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.config;

import com.enderio.core.EnderCore;
import com.enderio.core.api.common.config.IConfigHandler;
import com.enderio.core.common.config.AbstractConfigHandler;
import com.enderio.core.common.config.ConfigHandler;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;

public class BaseConfigGui
extends GuiConfig {
    public BaseConfigGui(GuiScreen parentScreen) {
        super(parentScreen, new ArrayList(), null, false, false, null);
        try {
            Field modIDField = GuiConfig.class.getDeclaredField("modID");
            Field configElementsField = GuiConfig.class.getDeclaredField("configElements");
            modIDField.setAccessible(true);
            configElementsField.setAccessible(true);
            modIDField.set((Object)this, this.getConfigHandler().getModID());
            configElementsField.set((Object)this, this.getConfigElements());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.title = this.getTitle();
    }

    protected String getTitle() {
        return EnderCore.lang.localize("config.title");
    }

    protected IConfigHandler getConfigHandler() {
        return ConfigHandler.instance();
    }

    protected String getLangPrefix() {
        return "config.";
    }

    private List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        String prefix = this.getLangPrefix();
        IConfigHandler config = this.getConfigHandler();
        prefix = prefix.endsWith(".") ? prefix : prefix + ".";
        for (AbstractConfigHandler.Section s : config.getSections()) {
            list.add((IConfigElement)new ConfigSection(s, prefix));
        }
        return list;
    }

    private static class ConfigElementExtended
    extends ConfigElement {
        private static final Field _prop;

        ConfigElementExtended(IConfigElement other) {
            super(ConfigElementExtended.getProp(other));
        }

        private static Property getProp(IConfigElement other) {
            try {
                return (Property)_prop.get(other);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public String getComment() {
            String comment = super.getComment();
            String range = "[range:";
            String def = "[default:";
            if (comment.contains(range)) {
                comment = comment.substring(0, comment.indexOf(range) - 1);
            } else if (comment.contains(def)) {
                comment = comment.substring(0, comment.indexOf(def) - 1);
            }
            return comment;
        }

        static {
            try {
                _prop = ConfigElement.class.getDeclaredField("prop");
                _prop.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ConfigSection
    extends ConfigElement {
        private AbstractConfigHandler.Section section;
        private String prefix;

        ConfigSection(AbstractConfigHandler.Section s, String prefix) {
            super(BaseConfigGui.this.getConfigHandler().getCategory(s.lc()).setLanguageKey(prefix + s.lang));
            this.section = s;
            this.prefix = prefix;
        }

        public List<IConfigElement> getChildElements() {
            List temp = super.getChildElements();
            ArrayList<IConfigElement> ret = new ArrayList<IConfigElement>(temp.size());
            for (IConfigElement e : temp) {
                if (e.isProperty()) {
                    ret.add((IConfigElement)new ConfigElementExtended(e));
                    continue;
                }
                ret.add((IConfigElement)new ConfigSection(this.section, this.prefix));
            }
            return ret;
        }
    }
}

