/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import com.github.vfyjxf.nee.client.KeyBindings;
import com.github.vfyjxf.nee.jei.CraftingHelperTransferHandler;
import com.github.vfyjxf.nee.utils.Ingredient;
import com.github.vfyjxf.nee.utils.IngredientTracker;
import java.awt.Color;
import java.util.ArrayList;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.gui.TooltipRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class CraftingHelperTooltipError
implements IRecipeTransferError {
    private static final Color craftableColor = new Color(0.0f, 0.0f, 1.0f, 0.4f);
    private static final Color missingColor = new Color(1.0f, 0.0f, 0.0f, 0.4f);
    private IngredientTracker tracker;
    private boolean isCraftingTerm;

    public CraftingHelperTooltipError() {
    }

    public CraftingHelperTooltipError(IngredientTracker tracker, boolean isCraftingTerm) {
        this.tracker = tracker;
        this.isCraftingTerm = isCraftingTerm;
    }

    public IRecipeTransferError.Type getType() {
        return IRecipeTransferError.Type.USER_FACING;
    }

    public void showError(Minecraft minecraft, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
        boolean drawTooltipInCraftingTerm = false;
        boolean drawTooltipInPattenTerm = false;
        boolean drawMissingItemTooltip = false;
        ArrayList<String> tooltips = new ArrayList<String>();
        for (Ingredient ingredient : this.tracker.getIngredients()) {
            if (this.isCraftingTerm) {
                if (!CraftingHelperTransferHandler.isIsPatternInterfaceExists()) {
                    if (ingredient.requiresToCraft() && ingredient.isCraftable()) {
                        drawTooltipInCraftingTerm = true;
                        ingredient.getIngredient().drawHighlight(minecraft, craftableColor, recipeX, recipeY);
                        continue;
                    }
                    if (!ingredient.requiresToCraft()) continue;
                    drawMissingItemTooltip = true;
                    ingredient.getIngredient().drawHighlight(minecraft, missingColor, recipeX, recipeY);
                    continue;
                }
                if (!ingredient.isCraftable()) continue;
                ingredient.getIngredient().drawHighlight(minecraft, craftableColor, recipeX, recipeY);
                continue;
            }
            if (!ingredient.isCraftable()) continue;
            drawTooltipInPattenTerm = true;
            ingredient.getIngredient().drawHighlight(minecraft, craftableColor, recipeX, recipeY);
        }
        if (drawTooltipInCraftingTerm) {
            tooltips.add(String.format("%s" + TextFormatting.GRAY + " + " + TextFormatting.BLUE + I18n.func_135052_a((String)"jei.tooltip.nee.helper.crafting.text1", (Object[])new Object[0]), TextFormatting.YELLOW + Keyboard.getKeyName((int)KeyBindings.craftingHelperPreview.func_151463_i())));
        }
        if (drawTooltipInPattenTerm) {
            tooltips.add(TextFormatting.BLUE + I18n.func_135052_a((String)"jei.tooltip.nee.helper.pattern", (Object[])new Object[0]));
        }
        if (drawMissingItemTooltip) {
            tooltips.add(TextFormatting.RED + I18n.func_135052_a((String)"jei.tooltip.error.recipe.transfer.missing", (Object[])new Object[0]));
        }
        if (CraftingHelperTransferHandler.isIsPatternInterfaceExists()) {
            tooltips.add(String.format("%s" + TextFormatting.GRAY + " + " + TextFormatting.BLUE + I18n.func_135052_a((String)"jei.tooltip.nee.helper.crafting.text2", (Object[])new Object[0]), TextFormatting.YELLOW + Keyboard.getKeyName((int)KeyBindings.craftingHelperPreview.func_151463_i())));
        }
        TooltipRenderer.drawHoveringText((Minecraft)minecraft, tooltips, (int)mouseX, (int)mouseY);
    }
}

