/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketJEIRecipe;
import appeng.helpers.IContainerCraftingPacket;
import appeng.util.Platform;
import com.github.vfyjxf.nee.client.KeyBindings;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.jei.CraftingHelperTooltipError;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketOpenCraftAmount;
import com.github.vfyjxf.nee.network.packet.PacketValueConfigServer;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.IngredientTracker;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.github.vfyjxf.nee.utils.StackProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import p455w0rd.wct.container.ContainerWCT;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.sync.WCTPacket;

public class CraftingHelperTransferHandler<C extends AEBaseContainer>
implements IRecipeTransferHandler<C> {
    public static IngredientTracker tracker = null;
    public static boolean noPreview = false;
    private final Class<C> containerClass;
    private static boolean isPatternInterfaceExists = false;
    public static final int RECIPE_LENGTH = 9;

    public CraftingHelperTransferHandler(Class<C> containerClass) {
        this.containerClass = containerClass;
    }

    @Nonnull
    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull C container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (container instanceof IContainerCraftingPacket && Minecraft.func_71410_x().field_71462_r instanceof RecipesGui) {
            RecipesGui recipesGui = (RecipesGui)Minecraft.func_71410_x().field_71462_r;
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketValueConfigServer("PatternInterface.check"));
            if (doTransfer) {
                boolean doCraftingHelp = Keyboard.isKeyDown((int)KeyBindings.craftingHelperPreview.func_151463_i()) || Keyboard.isKeyDown((int)KeyBindings.craftingHelperNoPreview.func_151463_i());
                noPreview = Keyboard.isKeyDown((int)KeyBindings.craftingHelperNoPreview.func_151463_i());
                if (doCraftingHelp) {
                    if (isPatternInterfaceExists) {
                        if (!GuiUtils.isWirelessCraftingTermContainer(container)) {
                            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketOpenCraftAmount(this.packCraftingRecipe(recipeLayout)));
                        } else if (Loader.isModLoaded((String)"wct")) {
                            this.openWirelessCraftingAmountGui((Container)container, recipeLayout);
                        }
                        isPatternInterfaceExists = false;
                    } else {
                        tracker = new IngredientTracker((AEBaseContainer)container, recipeLayout, player, recipesGui);
                        if (!tracker.getRequireStacks().isEmpty()) {
                            tracker.requestNextIngredient();
                        } else {
                            this.moveItems((AEBaseContainer)container, recipeLayout);
                        }
                    }
                } else {
                    this.moveItems((AEBaseContainer)container, recipeLayout);
                }
            } else {
                if (isPatternInterfaceExists) {
                    return new CraftingHelperTooltipError(new IngredientTracker(recipeLayout, recipesGui), true);
                }
                return new CraftingHelperTooltipError(new IngredientTracker((AEBaseContainer)container, recipeLayout, player, recipesGui), true);
            }
        }
        return null;
    }

    private void moveItems(AEBaseContainer container, IRecipeLayout recipeLayout) {
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        NBTTagCompound recipe = new NBTTagCompound();
        int slotIndex = 0;
        for (Map.Entry ingredientEntry : ingredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)ingredientEntry.getValue();
            if (!ingredient.isInput()) continue;
            for (Slot slot : container.field_75151_b) {
                if (!(slot instanceof SlotCraftingMatrix) && !(slot instanceof SlotFakeCraftingMatrix) || slot.getSlotIndex() != slotIndex) continue;
                NBTTagList tags = new NBTTagList();
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                ItemStack displayed = (ItemStack)ingredient.getDisplayedIngredient();
                if (displayed != null && !displayed.func_190926_b()) {
                    list.add(displayed);
                }
                for (ItemStack stack : ingredient.getAllIngredients()) {
                    if (Platform.isRecipePrioritized((ItemStack)stack)) {
                        list.add(0, stack);
                        continue;
                    }
                    list.add(stack);
                }
                for (ItemStack is : list) {
                    NBTTagCompound tag = new NBTTagCompound();
                    is.func_77955_b(tag);
                    tags.func_74742_a((NBTBase)tag);
                }
                recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                break;
            }
            ++slotIndex;
        }
        try {
            if (container instanceof ContainerCraftingTerm) {
                NetworkHandler.instance().sendToServer((AppEngPacket)new PacketJEIRecipe(recipe));
            } else if (GuiUtils.isWirelessCraftingTermContainer(container)) {
                this.moveItemsForWirelessTerm(recipe);
            }
        }
        catch (IOException e) {
            AELog.debug((Throwable)e);
        }
    }

    private ItemStack getRecipeOutput(IRecipeLayout recipeLayout) {
        ItemStack recipeOutput = ItemStack.field_190927_a;
        for (IGuiIngredient guiIngredient : recipeLayout.getItemStacks().getGuiIngredients().values()) {
            if (guiIngredient.isInput() || guiIngredient.getDisplayedIngredient() == null || ((ItemStack)guiIngredient.getDisplayedIngredient()).func_190926_b()) continue;
            recipeOutput = ((ItemStack)guiIngredient.getDisplayedIngredient()).func_77946_l();
        }
        return recipeOutput;
    }

    private NBTTagCompound packCraftingRecipe(IRecipeLayout recipeLayout) {
        NBTTagCompound recipe = new NBTTagCompound();
        NBTTagCompound reslut = null;
        String recipeType = recipeLayout.getRecipeCategory().getUid();
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        int inputIndex = 0;
        ArrayList<StackProcessor> tInputs = new ArrayList<StackProcessor>();
        for (Map.Entry entry : ingredients.entrySet()) {
            ItemStack currentStack;
            IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
            if (ingredient == null) continue;
            ItemStack displayedIngredient = ingredient.getDisplayedIngredient() == null ? ItemStack.field_190927_a : ((ItemStack)ingredient.getDisplayedIngredient()).func_77946_l();
            ItemStack firstIngredient = ingredient.getAllIngredients().isEmpty() ? ItemStack.field_190927_a : ((ItemStack)ingredient.getAllIngredients().get(0)).func_77946_l();
            ItemStack itemStack = currentStack = NEEConfig.useDisplayedIngredient ? displayedIngredient : firstIngredient;
            if (ingredient.isInput()) {
                tInputs.add(new StackProcessor((IGuiIngredient<ItemStack>)ingredient, currentStack, currentStack.func_190916_E()));
                continue;
            }
            if (currentStack.func_190926_b() || reslut != null) continue;
            reslut = currentStack.func_77955_b(new NBTTagCompound());
            recipe.func_74782_a("Outputs", (NBTBase)reslut);
        }
        for (StackProcessor currentIngredient : tInputs) {
            ItemStack preferModItem;
            ItemStack currentStack = currentIngredient.getCurrentStack();
            ItemStack itemStack = preferModItem = ItemUtils.isPreferModItem(currentStack) ? currentStack : ItemUtils.getPreferModItem(currentIngredient.getIngredient());
            if (!currentStack.func_190926_b()) {
                currentStack.func_190920_e(currentIngredient.getStackSize());
            }
            if (!currentStack.func_190926_b() && preferModItem != null && !preferModItem.func_190926_b()) {
                currentStack = preferModItem.func_77946_l();
                currentStack.func_190920_e(currentIngredient.getStackSize());
            }
            for (ItemStack stack : currentIngredient.getIngredient().getAllIngredients()) {
                if (!ItemUtils.isPreferItems(stack, recipeType) || currentStack.func_190926_b()) continue;
                currentStack = stack.func_77946_l();
                currentStack.func_190920_e(currentIngredient.getStackSize());
            }
            recipe.func_74782_a("#" + inputIndex, (NBTBase)currentStack.func_77955_b(new NBTTagCompound()));
            ++inputIndex;
        }
        return recipe;
    }

    @Optional.Method(modid="wct")
    private void openWirelessCraftingAmountGui(Container container, IRecipeLayout recipeLayout) {
        if (container instanceof ContainerWCT) {
            ContainerWCT wct = (ContainerWCT)container;
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketOpenCraftAmount(this.packCraftingRecipe(recipeLayout), wct.isWTBauble(), wct.getWTSlot()));
        }
    }

    @Optional.Method(modid="wct")
    private void moveItemsForWirelessTerm(NBTTagCompound recipe) {
        try {
            ModNetworking.instance().sendToServer((WCTPacket)new p455w0rd.wct.sync.packets.PacketJEIRecipe(recipe));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isIsPatternInterfaceExists() {
        return isPatternInterfaceExists;
    }

    public static void setIsPatternInterfaceExists(boolean isPatternInterfaceExists) {
        CraftingHelperTransferHandler.isPatternInterfaceExists = isPatternInterfaceExists;
    }
}

