/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import appeng.client.gui.AEBaseGui;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.container.implementations.ContainerPatternTerm;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.jei.CraftingHelperTransferHandler;
import com.github.vfyjxf.nee.jei.NEEGhostIngredientHandler;
import com.github.vfyjxf.nee.jei.PatternRecipeTransferHandler;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.collect.Table;
import mezz.jei.recipes.RecipeTransferRegistry;
import mezz.jei.util.ErrorUtil;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import p455w0rd.wct.container.ContainerWCT;

@JEIPlugin
public class NEEJEIPlugin
implements IModPlugin {
    public void register(IModRegistry registry) {
        MyTable recipeTransferHandlers = new MyTable(new HashMap(), HashMap::new);
        for (Table.Cell currentCell : ((RecipeTransferRegistry)registry.getRecipeTransferRegistry()).getRecipeTransferHandlers().cellSet()) {
            ErrorUtil.checkNotNull((Object)currentCell.getValue(), (String)"recipeTransferHandler");
            ErrorUtil.checkNotNull((Object)currentCell.getColumnKey(), (String)"recipeCategoryUid");
            ErrorUtil.checkNotNull((Object)currentCell.getRowKey(), (String)"containerClass");
            recipeTransferHandlers.put(currentCell.getRowKey(), currentCell.getColumnKey(), currentCell.getValue());
        }
        ObfuscationReflectionHelper.setPrivateValue(RecipeTransferRegistry.class, (Object)((RecipeTransferRegistry)registry.getRecipeTransferRegistry()), recipeTransferHandlers, (String)"recipeTransferHandlers");
        registry.addGhostIngredientHandler(AEBaseGui.class, (IGhostIngredientHandler)new NEEGhostIngredientHandler());
    }

    private Class<?> getContainerClass() {
        try {
            return Class.forName("p455w0rd.wct.container.ContainerWCT");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private class MyTable<R, C, V>
    extends Table<R, C, V> {
        private final Class<?> wirelessContainerClass;

        public MyTable(Map<R, Map<C, V>> table, Supplier<Map<C, V>> rowSupplier) {
            super(table, rowSupplier);
            this.wirelessContainerClass = NEEJEIPlugin.this.getContainerClass();
        }

        @Nullable
        public V put(R row, C col, V val) {
            if (row == ContainerPatternTerm.class && !(val instanceof PatternRecipeTransferHandler)) {
                col = "universal recipe transfer handler";
                val = new PatternRecipeTransferHandler();
                NotEnoughEnergistics.logger.info("AE2 PatternRecipeTransfeHandler Replaced Successfully (Overwrite Denied)");
            }
            if (row == ContainerCraftingTerm.class && !(val instanceof CraftingHelperTransferHandler)) {
                val = new CraftingHelperTransferHandler<ContainerCraftingTerm>(ContainerCraftingTerm.class);
                NotEnoughEnergistics.logger.info("AE2 RecipeTransfeHandler Replaced Successfully (Overwrite Denied)");
            }
            if (row == this.wirelessContainerClass && !(val instanceof CraftingHelperTransferHandler)) {
                val = new CraftingHelperTransferHandler<ContainerWCT>(ContainerWCT.class);
                NotEnoughEnergistics.logger.info("Wireless Crafting Terminal RecipeTransfeHandler Replaced Successfully");
            }
            return (V)super.put(row, col, val);
        }
    }
}

