/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.slot.SlotFake;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStackSizeChange
implements IMessage,
IMessageHandler<PacketStackSizeChange, IMessage> {
    private int slotIndex;
    private int changeCount;

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public PacketStackSizeChange() {
    }

    public PacketStackSizeChange(int slotIndex, int changeCount) {
        this.slotIndex = slotIndex;
        this.changeCount = changeCount;
    }

    public void fromBytes(ByteBuf buf) {
        this.slotIndex = buf.readInt();
        this.changeCount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slotIndex);
        buf.writeInt(this.changeCount);
    }

    public IMessage onMessage(PacketStackSizeChange message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Container container = player.field_71070_bA;
        player.func_71121_q().func_152344_a(() -> {
            if (container instanceof AEBaseContainer) {
                if (container instanceof ContainerPatternTerm && ((ContainerPatternTerm)container).isCraftingMode()) {
                    return;
                }
                Slot currentSlot = container.func_75139_a(message.getSlotIndex());
                if (currentSlot instanceof SlotFake && currentSlot.func_75216_d()) {
                    for (int i = 0; i < Math.abs(message.getChangeCount()); ++i) {
                        int currentStackSize;
                        int n = currentStackSize = message.getChangeCount() > 0 ? currentSlot.func_75211_c().func_190916_E() + 1 : currentSlot.func_75211_c().func_190916_E() - 1;
                        if (currentStackSize > currentSlot.func_75211_c().func_77976_d() || currentStackSize <= 0) break;
                        ItemStack nextStack = currentSlot.func_75211_c().func_77946_l();
                        nextStack.func_190920_e(currentStackSize);
                        currentSlot.func_75215_d(nextStack);
                    }
                }
            }
        });
        return null;
    }
}

