/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.client.me.ItemRepo;
import appeng.container.AEBaseContainer;
import appeng.helpers.IContainerCraftingPacket;
import appeng.util.item.AEItemStack;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.jei.CraftingHelperTransferHandler;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketCraftingRequest;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.Ingredient;
import com.github.vfyjxf.nee.utils.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import p455w0rd.wct.client.gui.GuiWCT;

public class IngredientTracker {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private AEBaseContainer termContainer;
    private final GuiScreen parentScreen;
    private EntityPlayer player;
    private List<ItemStack> requireStacks;
    private int currentIndex = 0;

    public IngredientTracker(IRecipeLayout recipeLayout, RecipesGui recipesGui) {
        this.parentScreen = recipesGui.getParentScreen();
        for (IGuiIngredient guiIngredient : recipeLayout.getItemStacks().getGuiIngredients().values()) {
            if (!guiIngredient.isInput() || guiIngredient.getAllIngredients().isEmpty() || !guiIngredient.getAllIngredients().stream().anyMatch(stack -> stack != null && !stack.func_190926_b())) continue;
            this.ingredients.add(new Ingredient((IGuiIngredient<ItemStack>)guiIngredient));
        }
        for (Ingredient ingredient : this.ingredients) {
            for (IAEItemStack stack2 : this.getCraftableStacks()) {
                if (ItemUtils.getIngredientIndex(stack2.asItemStackRepresentation(), ingredient.getIngredient().getAllIngredients()) < 0 || !ingredient.getCraftableIngredient().func_190926_b()) continue;
                ingredient.setCraftableIngredient(stack2.asItemStackRepresentation());
            }
        }
    }

    public IngredientTracker(AEBaseContainer termContainer, IRecipeLayout recipeLayout, EntityPlayer player, RecipesGui recipesGui) {
        this.termContainer = termContainer;
        this.player = player;
        this.parentScreen = recipesGui.getParentScreen();
        for (IGuiIngredient guiIngredient : recipeLayout.getItemStacks().getGuiIngredients().values()) {
            if (!guiIngredient.isInput() || guiIngredient.getAllIngredients().isEmpty() || !guiIngredient.getAllIngredients().stream().anyMatch(stack -> stack != null && !stack.func_190926_b())) continue;
            this.ingredients.add(new Ingredient((IGuiIngredient<ItemStack>)guiIngredient));
        }
        for (Ingredient ingredient : this.ingredients) {
            for (IAEItemStack stack2 : this.getCraftableStacks()) {
                if (ItemUtils.getIngredientIndex(stack2.asItemStackRepresentation(), ingredient.getIngredient().getAllIngredients()) < 0 || !ingredient.getCraftableIngredient().func_190926_b() || !stack2.isCraftable()) continue;
                ingredient.setCraftableIngredient(stack2.asItemStackRepresentation());
            }
        }
        this.calculateIngredients();
    }

    private List<IAEItemStack> getStorageStacks() {
        ArrayList<IAEItemStack> list = new ArrayList<IAEItemStack>();
        if (this.parentScreen != null) {
            ItemRepo repo = null;
            if (this.parentScreen instanceof GuiCraftingTerm || this.parentScreen instanceof GuiPatternTerm) {
                repo = (ItemRepo)ObfuscationReflectionHelper.getPrivateValue(GuiMEMonitorable.class, (Object)((GuiMEMonitorable)this.parentScreen), (String)"repo");
            } else if (GuiUtils.isGuiWirelessCrafting(this.parentScreen)) {
                repo = (ItemRepo)ObfuscationReflectionHelper.getPrivateValue(GuiWCT.class, (Object)((GuiWCT)this.parentScreen), (String)"repo");
            }
            if (repo != null) {
                for (IAEItemStack stack : (IItemList)ObfuscationReflectionHelper.getPrivateValue(ItemRepo.class, (Object)repo, (String)"list")) {
                    list.add(stack.copy());
                }
            }
        }
        return list;
    }

    private List<IAEItemStack> getCraftableStacks() {
        ArrayList<IAEItemStack> craftableStacks = new ArrayList<IAEItemStack>();
        if (this.parentScreen != null) {
            ItemRepo repo = null;
            if (this.parentScreen instanceof GuiCraftingTerm || this.parentScreen instanceof GuiPatternTerm) {
                repo = (ItemRepo)ObfuscationReflectionHelper.getPrivateValue(GuiMEMonitorable.class, (Object)((GuiMEMonitorable)this.parentScreen), (String)"repo");
            } else if (GuiUtils.isGuiWirelessCrafting(this.parentScreen)) {
                repo = (ItemRepo)ObfuscationReflectionHelper.getPrivateValue(GuiWCT.class, (Object)((GuiWCT)this.parentScreen), (String)"repo");
            }
            if (repo != null) {
                for (IAEItemStack stack : (IItemList)ObfuscationReflectionHelper.getPrivateValue(ItemRepo.class, (Object)repo, (String)"list")) {
                    if (!stack.isCraftable()) continue;
                    craftableStacks.add(stack.copy());
                }
            }
        }
        return craftableStacks;
    }

    public List<ItemStack> getRequireToCraftStacks() {
        ArrayList<ItemStack> requireToCraftStacks = new ArrayList<ItemStack>();
        for (Ingredient ingredient : this.getIngredients()) {
            boolean find = false;
            if (!ingredient.isCraftable() || !ingredient.requiresToCraft()) continue;
            for (ItemStack stack : requireToCraftStacks) {
                boolean areStackEqual = stack.func_77969_a(ingredient.getCraftableIngredient()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)ingredient.getCraftableIngredient());
                if (!areStackEqual) continue;
                stack.func_190920_e((int)((long)stack.func_190916_E() + ingredient.getMissingCount()));
                find = true;
                break;
            }
            if (find) continue;
            ItemStack requireStack = ingredient.getCraftableIngredient().func_77946_l();
            requireStack.func_190920_e((int)ingredient.getMissingCount());
            requireToCraftStacks.add(requireStack);
        }
        return requireToCraftStacks;
    }

    public List<ItemStack> getRequireStacks() {
        return this.requireStacks;
    }

    public ItemStack getRequiredStack(int index) {
        return this.getRequireStacks().get(index);
    }

    public boolean hasCraftableIngredient() {
        for (Ingredient ingredient : this.getIngredients()) {
            if (!ingredient.isCraftable()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        return this.currentIndex < this.getRequireStacks().size();
    }

    public void requestNextIngredient() {
        AEItemStack stack = AEItemStack.fromItemStack((ItemStack)this.getRequiredStack(this.currentIndex));
        if (stack != null) {
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketCraftingRequest((IAEItemStack)stack, CraftingHelperTransferHandler.noPreview));
        }
        ++this.currentIndex;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void addAvailableStack(ItemStack stack) {
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.requiresToCraft()) continue;
            if (NEEConfig.matchOtherItems) {
                boolean canUse = stack.func_190916_E() > 0 && ItemUtils.getIngredientIndex(stack, ingredient.getIngredient().getAllIngredients()) >= 0;
                if (!canUse) continue;
                int missingCount = (int)ingredient.getMissingCount();
                ingredient.addCount(stack.func_190916_E());
                if (ingredient.requiresToCraft()) {
                    stack.func_190920_e(0);
                    break;
                }
                stack.func_190920_e(stack.func_190916_E() - missingCount);
                break;
            }
            ItemStack craftableStack = ingredient.getCraftableIngredient();
            if (craftableStack.func_190926_b() || !craftableStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)craftableStack, (ItemStack)stack)) continue;
            int missingCount = (int)ingredient.getMissingCount();
            ingredient.addCount(stack.func_190916_E());
            if (ingredient.requiresToCraft()) {
                stack.func_190920_e(0);
                break;
            }
            stack.func_190920_e(stack.func_190916_E() - missingCount);
            break;
        }
    }

    public void calculateIngredients() {
        List<IAEItemStack> stacks = NEEConfig.matchOtherItems ? this.getStorageStacks() : this.getCraftableStacks();
        for (Ingredient ingredient : this.ingredients) {
            for (IAEItemStack stack : stacks) {
                if (ItemUtils.getIngredientIndex(stack.asItemStackRepresentation(), ingredient.getIngredient().getAllIngredients()) < 0 || stack.getStackSize() <= 0L) continue;
                ingredient.addCount(stack.getStackSize());
                if (ingredient.requiresToCraft()) {
                    stack.setStackSize(0L);
                    continue;
                }
                stack.setStackSize(stack.getStackSize() - ingredient.getRequireCount());
            }
        }
        ArrayList<ItemStack> inventoryStacks = new ArrayList<ItemStack>();
        for (int slotIndex = 0; slotIndex < this.player.field_71071_by.func_70302_i_(); ++slotIndex) {
            if (this.player.field_71071_by.func_70301_a(slotIndex).func_190926_b()) continue;
            inventoryStacks.add(this.player.field_71071_by.func_70301_a(slotIndex).func_77946_l());
        }
        if (this.termContainer instanceof IContainerCraftingPacket) {
            IContainerCraftingPacket ccp = (IContainerCraftingPacket)this.termContainer;
            IItemHandler craftMatrix = ccp.getInventoryByName("crafting");
            for (int slotIndex = 0; slotIndex < craftMatrix.getSlots(); ++slotIndex) {
                if (craftMatrix.getStackInSlot(slotIndex).func_190926_b()) continue;
                inventoryStacks.add(craftMatrix.getStackInSlot(slotIndex).func_77946_l());
            }
        }
        for (int i = 0; i < this.getIngredients().size(); ++i) {
            for (ItemStack stack : inventoryStacks) {
                this.addAvailableStack(stack);
            }
        }
        this.requireStacks = this.getRequireToCraftStacks();
    }
}

