/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.asm;

import com.google.common.base.Preconditions;
import cubex2.cs4.asm.ModInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class ModClassGenerator {
    private static final String MOD_LOADER = "cubex2/cs4/ModLoader";
    private static final String CS4_MOD = "cubex2/cs4/CS4Mod";
    private static final String PRE_INIT_EVENT = "net/minecraftforge/fml/common/event/FMLPreInitializationEvent";
    private static final String INIT_EVENT = "net/minecraftforge/fml/common/event/FMLInitializationEvent";
    private static final String POST_INIT_EVENT = "net/minecraftforge/fml/common/event/FMLPostInitializationEvent";
    private static final String REGISTER_BLOCKS_EVENT = "net/minecraftforge/event/RegistryEvent$Register";
    private static final String REGISTER_BLOCKS_SIGNATURE = "net/minecraftforge/event/RegistryEvent$Register<Lnet/minecraft/block/Block;>";
    private static final String REGISTER_ITEMS_EVENT = "net/minecraftforge/event/RegistryEvent$Register";
    private static final String REGISTER_ITEMS_SIGNATURE = "net/minecraftforge/event/RegistryEvent$Register<Lnet/minecraft/item/Item;>";
    private static final String REGISTER_MODELS_EVENT = "net/minecraftforge/client/event/ModelRegistryEvent";
    private static final String EVENT_HANDLER = "net/minecraftforge/fml/common/Mod$EventHandler";
    private static final String MOD = "net/minecraftforge/fml/common/Mod";
    private static final String EVENT_BUS = "net/minecraftforge/fml/common/eventhandler/EventBus";
    private static final String SUBSCRIBE_EVENT = "net/minecraftforge/fml/common/eventhandler/SubscribeEvent";

    public static void createModClass(File modFolder, ModInfo info) {
        File classFile = ModClassGenerator.getClassFile(modFolder, info.id);
        if (!classFile.exists()) {
            classFile.getParentFile().mkdirs();
            byte[] bytes = ModClassGenerator.generateClassCode(info);
            ModClassGenerator.writeBytesToFile(bytes, classFile);
        }
    }

    private static File getClassFile(File modFolder, String modId) {
        return new File(modFolder, "cs4mod/" + modId + ".class");
    }

    private static byte[] generateClassCode(ModInfo info) {
        Preconditions.checkArgument((boolean)info.isValid(), (Object)"Invalid mod id");
        ClassWriter cw = new ClassWriter(0);
        cw.visit(51, 33, "cs4mod/" + info.id, null, "java/lang/Object", new String[]{CS4_MOD});
        AnnotationVisitor av = cw.visitAnnotation(String.format("L%s;", MOD), true);
        av.visit("modid", (Object)info.id);
        av.visit("name", (Object)info.name);
        av.visit("version", (Object)info.version);
        av.visit("dependencies", (Object)String.format("required-after:%s;%s", "customstuff4", info.dependencies));
        av.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitFieldInsn(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", ModClassGenerator.desc(EVENT_BUS));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, EVENT_BUS, "register", ModClassGenerator.voidMethodDesc("java/lang/Object"), false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "preInit", ModClassGenerator.voidMethodDesc(PRE_INIT_EVENT), null, null);
        av = mv.visitAnnotation(String.format("L%s;", EVENT_HANDLER), true);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, MOD_LOADER, "onPreInitMod", ModClassGenerator.voidMethodDesc(CS4_MOD), false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "init", ModClassGenerator.voidMethodDesc(INIT_EVENT), null, null);
        av = mv.visitAnnotation(String.format("L%s;", EVENT_HANDLER), true);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, MOD_LOADER, "onInitMod", ModClassGenerator.voidMethodDesc(CS4_MOD), false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "postInit", ModClassGenerator.voidMethodDesc(POST_INIT_EVENT), null, null);
        av = mv.visitAnnotation(String.format("L%s;", EVENT_HANDLER), true);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, MOD_LOADER, "onPostInitMod", ModClassGenerator.voidMethodDesc(CS4_MOD), false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "onRegisterBlocks", ModClassGenerator.voidMethodDesc("net/minecraftforge/event/RegistryEvent$Register"), ModClassGenerator.voidMethodDesc(REGISTER_BLOCKS_SIGNATURE), null);
        av = mv.visitAnnotation(ModClassGenerator.desc(SUBSCRIBE_EVENT), true);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, MOD_LOADER, "onRegisterBlocks", ModClassGenerator.voidMethodDesc(CS4_MOD), false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "onRegisterItems", ModClassGenerator.voidMethodDesc("net/minecraftforge/event/RegistryEvent$Register"), ModClassGenerator.voidMethodDesc(REGISTER_ITEMS_SIGNATURE), null);
        av = mv.visitAnnotation(ModClassGenerator.desc(SUBSCRIBE_EVENT), true);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, MOD_LOADER, "onRegisterItems", ModClassGenerator.voidMethodDesc(CS4_MOD), false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "onRegisterModels", ModClassGenerator.voidMethodDesc(REGISTER_MODELS_EVENT), null, null);
        av = mv.visitAnnotation(ModClassGenerator.desc(SUBSCRIBE_EVENT), true);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, MOD_LOADER, "onRegisterModels", ModClassGenerator.voidMethodDesc(CS4_MOD), false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        return cw.toByteArray();
    }

    private static String voidMethodDesc(String param) {
        return String.format("(L%s;)V", param);
    }

    private static String desc(String className) {
        return String.format("L%s;", className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBytesToFile(byte[] bytes, File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
    }
}

