/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.compat.jei;

import com.google.common.collect.Lists;
import cubex2.cs4.api.RecipeInput;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipe;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipeOutput;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MachineRecipeWrapper
implements IRecipeWrapper {
    private final MachineRecipe recipe;
    private final MachineRecipeOutput output;
    private final IJeiHelpers jeiHelpers;
    private final String cookTimeString;

    public MachineRecipeWrapper(MachineRecipe recipe, MachineRecipeOutput output, IJeiHelpers jeiHelpers) {
        this.recipe = recipe;
        this.output = output;
        this.jeiHelpers = jeiHelpers;
        this.cookTimeString = recipe.getCookTime() > 0 ? I18n.func_135052_a((String)"gui.cs4.jei.machineRecipe.cookTime", (Object[])new Object[]{recipe.getCookTime()}) : "";
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList inputs = Lists.newArrayList();
        for (RecipeInput input : this.recipe.getRecipeInput()) {
            if (input.isOreClass()) {
                inputs.add(input.getOreClass().getOreName());
                continue;
            }
            inputs.add(input.getStack().getItemStack().func_77946_l());
        }
        ingredients.setInputLists(ItemStack.class, this.jeiHelpers.getStackHelper().expandRecipeItemStackInputs((List)inputs));
        ingredients.setInputs(FluidStack.class, this.recipe.getFluidRecipeInput());
        ingredients.setOutputs(ItemStack.class, this.output.getOutputItems());
        ingredients.setOutputs(FluidStack.class, this.output.getOutputFluids());
    }
}

