/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.data.SimpleContent;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

class WorldGenOre
extends SimpleContent
implements IWorldGenerator {
    ResourceLocation block;
    int meta;
    int count = 1;
    int size = 10;
    int weight = 1;
    int minHeight = 0;
    int maxHeight = 64;
    ResourceLocation target;
    int targetMeta = -1;
    int dimension = 0;
    private transient WorldGenMinable gen;
    private transient Block targetBlock;

    WorldGenOre() {
    }

    @Override
    protected void doInit(InitPhase phase, ContentHelper helper) {
        if (this.target != null) {
            this.targetBlock = (Block)Block.field_149771_c.func_82594_a((Object)this.target);
        }
        this.createGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)this.weight);
    }

    private void createGenerator() {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)this.block);
        IBlockState state = block.func_176203_a(this.meta);
        this.gen = this.target == null ? new WorldGenMinable(state, this.size) : new WorldGenMinable(state, this.size, this::canGenerate);
    }

    private boolean canGenerate(@Nullable IBlockState state) {
        return state != null && this.isCorrectState(state);
    }

    private boolean isCorrectState(IBlockState state) {
        return state.func_177230_c() == this.targetBlock && (this.targetMeta == -1 || this.targetMeta == this.targetBlock.func_176201_c(state));
    }

    @Override
    protected boolean isReady() {
        boolean targetReady = this.target == null || this.target.equals((Object)Blocks.field_150350_a.getRegistryName()) || Block.field_149771_c.func_82594_a((Object)this.target) != Blocks.field_150350_a;
        boolean blockReady = this.block == null || Block.field_149771_c.func_82594_a((Object)this.block) != Blocks.field_150350_a;
        return targetReady && blockReady;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() != this.dimension) {
            return;
        }
        BlockPos chunkPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        if (this.maxHeight < this.minHeight) {
            int i = this.minHeight;
            this.minHeight = this.maxHeight;
            this.maxHeight = i;
        } else if (this.maxHeight == this.minHeight) {
            if (this.minHeight < 255) {
                ++this.maxHeight;
            } else {
                --this.minHeight;
            }
        }
        for (int j = 0; j < this.count; ++j) {
            BlockPos blockpos = chunkPos.func_177982_a(random.nextInt(16), random.nextInt(this.maxHeight - this.minHeight) + this.minHeight, random.nextInt(16));
            this.gen.func_180709_b(world, random, blockpos);
        }
    }
}

