/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cubex2.cs4.plugins.vanilla.block.StateMetaMapper;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class BitStateMetaMapper<B extends Block>
implements StateMetaMapper<B> {
    private static final int MAX_BITS = 4;
    private final List<Entry<?>> entries = Lists.newArrayList();
    private int totalBits = 0;

    public BitStateMetaMapper(Collection<IProperty<?>> properties) {
        properties.forEach(this::addProperty);
    }

    public BitStateMetaMapper(IProperty<?> ... properties) {
        for (IProperty<?> property : properties) {
            this.addProperty(property);
        }
    }

    private <T extends Comparable<T>> void addProperty(IProperty<T> property) {
        int numBits = BitStateMetaMapper.getBitCount(property.func_177700_c().size());
        Preconditions.checkArgument((this.totalBits + numBits <= 4 ? 1 : 0) != 0, (Object)("Not enough bits left for " + property.func_177700_c().size() + " values from property " + property.func_177701_a()));
        this.entries.add(new Entry<T>(property, numBits, this.totalBits));
        this.totalBits += numBits;
    }

    static int getBitCount(int n) {
        if (n == 1) {
            return 1;
        }
        int bits = 0;
        while (n > 1 << bits) {
            ++bits;
        }
        return bits;
    }

    @Override
    public IBlockState getStateFromMeta(B block, int meta) {
        IBlockState state = block.func_176223_P();
        for (Entry<?> entry : this.entries) {
            state = entry.addToState(state, meta);
        }
        return state;
    }

    @Override
    public int getMetaFromState(IBlockState state) {
        int meta = 0;
        for (Entry<?> entry : this.entries) {
            meta |= entry.getMetaBits(state);
        }
        return meta;
    }

    private static class Entry<T extends Comparable<T>> {
        final IProperty<T> property;
        final int bitOffset;
        final int numBits;
        final int bitMask;
        final List<T> values;

        Entry(IProperty<T> property, int numBits, int bitOffset) {
            Preconditions.checkArgument((numBits >= BitStateMetaMapper.getBitCount(property.func_177700_c().size()) ? 1 : 0) != 0, (Object)("Too many values for " + numBits + " bits"));
            this.property = property;
            this.bitOffset = bitOffset;
            this.numBits = numBits;
            this.bitMask = (1 << numBits) - 1 << bitOffset;
            this.values = ImmutableList.copyOf((Collection)property.func_177700_c());
        }

        IBlockState addToState(IBlockState state, int meta) {
            int index = (meta & this.bitMask) >> this.bitOffset;
            return state.func_177226_a(this.property, (Comparable)this.values.get(index));
        }

        int getMetaBits(IBlockState state) {
            Comparable value = state.func_177229_b(this.property);
            int index = this.values.indexOf(value);
            if (index >= 0) {
                return index << this.bitOffset;
            }
            return 0;
        }
    }
}

