/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.block;

import cubex2.cs4.plugins.vanilla.BlockDrop;
import cubex2.cs4.plugins.vanilla.ContentBlockCrops;
import cubex2.cs4.plugins.vanilla.block.CSBlock;
import cubex2.cs4.util.BlockHelper;
import cubex2.cs4.util.ItemHelper;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;

public abstract class BlockCrops
extends net.minecraft.block.BlockCrops
implements CSBlock<ContentBlockCrops> {
    private final ContentBlockCrops content;
    private final AxisAlignedBB[] aabbs;
    private PropertyInteger ageProperty;

    public BlockCrops(Material material, ContentBlockCrops content) {
        this.content = content;
        this.aabbs = this.createCropsAABB();
    }

    private AxisAlignedBB[] createCropsAABB() {
        AxisAlignedBB[] bounds = new AxisAlignedBB[this.content.maxAge + 1];
        if (this.content.heights.length == 0) {
            for (int i = 0; i < bounds.length; ++i) {
                bounds[i] = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)(i + 1) / (double)bounds.length, 1.0);
            }
        } else {
            for (int i = 0; i < bounds.length; ++i) {
                bounds[i] = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)this.content.heights[i], 1.0);
            }
        }
        return bounds;
    }

    public int func_185526_g() {
        return this.content.maxAge;
    }

    protected PropertyInteger func_185524_e() {
        return this.ageProperty;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.aabbs[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        Optional blockDrops = this.getContent().drop.get(this.getSubtype(state));
        if (blockDrops.isPresent()) {
            drops.addAll(ItemHelper.getDroppedStacks((BlockDrop[])blockDrops.get(), fortune));
        }
        int age = this.func_185527_x(state);
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (age >= this.func_185526_g()) {
            for (BlockDrop seed : this.content.seeds) {
                ItemStack stack = seed.getItem().getItemStack();
                if (stack.func_190926_b()) continue;
                for (int i = 0; i < 3 + fortune; ++i) {
                    if (rand.nextInt(2 * this.func_185526_g()) > age) continue;
                    ItemStack drop = stack.func_77946_l();
                    drop.func_190920_e(seed.getAmount(fortune));
                    drops.add((Object)drop);
                }
            }
            drops.addAll(ItemHelper.getDroppedStacks(this.content.crops, fortune));
        } else {
            drops.addAll(ItemHelper.getDroppedStacks(this.content.seeds, fortune));
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i;
        this.func_176475_e(worldIn, pos, state);
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = this.func_185527_x(state)) < this.func_185526_g()) {
            boolean shouldGrow;
            float f = BlockCrops.func_180672_a((Block)this, (World)worldIn, (BlockPos)pos);
            int growthChance = (int)((25.0f / f + 1.0f) / this.content.growthFactor);
            boolean bl = shouldGrow = rand.nextInt(Math.max(growthChance, 1)) == 0;
            if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)shouldGrow)) {
                worldIn.func_180501_a(pos, this.func_185528_e(i + 1), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.content.seeds.length > 0) {
            return this.content.seeds[0].getItem().getItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getSubtype(IBlockState state) {
        return 0;
    }

    @Override
    public ContentBlockCrops getContent() {
        return this.content;
    }

    protected BlockStateContainer func_180661_e() {
        if (this.ageProperty == null) {
            this.ageProperty = BlockHelper.getCropAgeProperty(ContentBlockCrops.activeMaxAge);
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.ageProperty});
    }
}

