/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.item;

import cubex2.cs4.mixin.Mixin;
import cubex2.cs4.plugins.vanilla.ContentItemBase;
import cubex2.cs4.plugins.vanilla.ContentItemFood;
import cubex2.cs4.plugins.vanilla.ContentItemSimple;
import cubex2.cs4.plugins.vanilla.item.ItemFood;
import cubex2.cs4.plugins.vanilla.item.ItemSimple;
import cubex2.cs4.plugins.vanilla.item.ItemWithSubtypesMixin;
import net.minecraft.item.Item;

public class ItemFactory {
    private static Class<? extends Item> foodClass = ItemFactory.createClass(ItemFood.class, ItemWithSubtypesMixin.class);
    private static Class<? extends Item> simpleClass = ItemFactory.createClass(ItemSimple.class, ItemWithSubtypesMixin.class);

    public static Item createFood(ContentItemFood content) {
        return ItemFactory.newInstance(foodClass, content);
    }

    public static Item createSimple(ContentItemSimple content) {
        return ItemFactory.newInstance(simpleClass, content);
    }

    private static <T extends ContentItemBase<?>> Item newInstance(Class<? extends Item> itemClass, T content) {
        try {
            return itemClass.getConstructor(content.getClass()).newInstance(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends Item> createClass(Class<?> baseClass, Class<?> ... mixins) {
        return Mixin.create(baseClass.getName().replace('.', '/') + "_created", baseClass, mixins);
    }
}

