/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.item;

import cubex2.cs4.CustomStuff4;
import cubex2.cs4.plugins.vanilla.ContentGuiBase;
import cubex2.cs4.plugins.vanilla.ContentItemWithSubtypes;
import cubex2.cs4.plugins.vanilla.GuiRegistry;
import cubex2.cs4.plugins.vanilla.item.CapabilityProviderItem;
import cubex2.cs4.plugins.vanilla.item.ItemWithSubtypes;
import cubex2.cs4.util.ItemHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLLog;

public abstract class ItemWithSubtypesMixin
extends Item
implements ItemWithSubtypes {
    private CreativeTabs[] tabs;

    public String func_77667_c(ItemStack stack) {
        if (this.field_77787_bX) {
            return super.func_77667_c(stack) + "." + stack.func_77960_j();
        }
        return super.func_77667_c(stack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getContent().maxStack.get(stack.func_77960_j()).orElse(64);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String[] lines = this.getContent().information.get(stack.func_77960_j()).orElse(new String[0]);
        tooltip.addAll(Arrays.asList(lines));
    }

    public CreativeTabs[] getCreativeTabs() {
        if (this.tabs == null) {
            this.tabs = ItemHelper.createCreativeTabs(this.getContent().creativeTab, this.getContent().subtypes);
        }
        return this.tabs;
    }

    public CreativeTabs func_77640_w() {
        CreativeTabs[] tabs = this.getCreativeTabs();
        return tabs.length == 0 ? null : tabs[0];
    }

    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(creativeTab)) {
            subItems.addAll(ItemHelper.createSubItems(this, creativeTab, this.getContent().creativeTab, this.getContent().subtypes));
        }
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return this.getContent().burnTime.get(itemStack.func_77960_j()).orElse(-1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Optional<ContentGuiBase> gui = this.getGui(stack.func_77960_j());
        if (gui.isPresent()) {
            playerIn.openGui((Object)CustomStuff4.INSTANCE, gui.get().getGuiId(), worldIn, handIn.ordinal(), -1, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private Optional<ContentGuiBase> getGui(int subtype) {
        Optional location = this.getContent().gui.get(subtype);
        if (location.isPresent()) {
            ContentGuiBase gui = GuiRegistry.get((ResourceLocation)location.get());
            if (gui == null) {
                FMLLog.warning((String)"Missing GUI %s", (Object[])new Object[]{location.get()});
            }
            return Optional.ofNullable(gui);
        }
        return Optional.empty();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!this.getContent().modules.isEmpty()) {
            return new CapabilityProviderItem(stack, this.getContent());
        }
        return null;
    }

    @Override
    public ContentItemWithSubtypes<?> getContent() {
        return null;
    }
}

