/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.util;

import com.google.common.base.Preconditions;
import java.util.Random;

public abstract class IntRange {
    public static final IntRange ZERO = IntRange.create(0, 0);

    public abstract int getMin();

    public abstract int getMax();

    public abstract int getRandomValue();

    public static IntRange create(int min, int max) {
        if (min != max) {
            return new RealRange(min, max);
        }
        return new SingleElementRange(min);
    }

    private static class RealRange
    extends IntRange {
        private static final Random RANDOM = new Random();
        private final int min;
        private final int max;

        public RealRange(int min, int max) {
            Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"min > max!");
            this.min = min;
            this.max = max;
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public int getMax() {
            return this.max;
        }

        @Override
        public int getRandomValue() {
            return RANDOM.nextInt(this.max - this.min + 1) + this.min;
        }
    }

    private static class SingleElementRange
    extends IntRange {
        private final int value;

        private SingleElementRange(int value) {
            this.value = value;
        }

        @Override
        public int getMin() {
            return this.value;
        }

        @Override
        public int getMax() {
            return this.value;
        }

        @Override
        public int getRandomValue() {
            return this.value;
        }
    }
}

