/*
 * Decompiled with CFR 0.152.
 */
package net.samtrion.compactdrawers.item;

import com.jaquadro.minecraft.chameleon.resources.IItemMeshMapper;
import com.jaquadro.minecraft.chameleon.resources.IItemVariantProvider;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.samtrion.compactdrawers.block.BlockCompactDrawerBase;
import net.samtrion.compactdrawers.block.IDrawerSerializable;
import org.apache.commons.lang3.tuple.Pair;

public class ItemCompactDrawer
extends ItemBlock
implements IItemMeshMapper,
IItemVariantProvider {
    private final BlockCompactDrawerBase block;
    private final IDrawerSerializable[] drawerValues;

    public ItemCompactDrawer(BlockCompactDrawerBase block, IDrawerSerializable[] drawerValues) {
        super((Block)block);
        this.block = block;
        this.drawerValues = drawerValues;
    }

    public List<ResourceLocation> getItemVariants() {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this);
        ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        for (IDrawerSerializable type : this.drawerValues) {
            variants.add(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + '_' + type.func_176610_l()));
        }
        return variants;
    }

    public List<Pair<ItemStack, ModelResourceLocation>> getMeshMappings() {
        ArrayList<Pair<ItemStack, ModelResourceLocation>> mappings = new ArrayList<Pair<ItemStack, ModelResourceLocation>>();
        for (IDrawerSerializable type : this.drawerValues) {
            ModelResourceLocation location = new ModelResourceLocation("compactdrawers:" + this.block.getName() + "_" + type.func_176610_l(), "inventory");
            mappings.add((Pair<ItemStack, ModelResourceLocation>)Pair.of((Object)new ItemStack((Item)this, 1, type.getMetadata()), (Object)location));
        }
        return mappings;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TileEntityDrawers tile = (TileEntityDrawers)world.func_175625_s(pos);
        if (tile != null) {
            if (side != EnumFacing.UP && side != EnumFacing.DOWN) {
                tile.setDirection(side.ordinal());
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tile")) {
                tile.readFromPortableNBT(stack.func_77978_p().func_74775_l("tile"));
            }
            tile.setIsSealed(false);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, List<String> list, ITooltipFlag advanced) {
        int count = this.block.getDrawerBaseStorage();
        list.add(I18n.func_135052_a((String)"storagedrawers.drawers.description", (Object[])new Object[]{count}));
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("tile")) {
            list.add(ChatFormatting.YELLOW + I18n.func_135052_a((String)"storagedrawers.drawers.sealed", (Object[])new Object[0]));
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        ItemCompactDrawer.createStackWithNBT(stack);
    }

    public static ItemStack createStackWithNBT(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack;
    }
}

