/*
 * Decompiled with CFR 0.152.
 */
package net.samtrion.compactdrawers.tile;

import com.jaquadro.minecraft.chameleon.block.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.samtrion.compactdrawers.tile.data.GroupData;

public abstract class TileEntityCompactDrawerBase
extends TileEntityDrawers {
    private final int capacity;
    private final GroupData groupData;
    private final String name;

    protected TileEntityCompactDrawerBase(int drawerCount, String name, int drawerCapacity) {
        this.name = name;
        this.capacity = drawerCapacity;
        this.groupData = new GroupData(drawerCount, this);
        this.groupData.setCapabilityProvider((ICapabilityProvider)this);
        this.injectPortableData((TileDataShim)this.groupData);
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IDrawerGroup getGroup() {
        return this.groupData;
    }

    public int getDrawerCapacity() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return super.getDrawerCapacity();
        }
        return this.capacity;
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        Minecraft.func_71410_x().func_152344_a(() -> this.clientUpdateCountAsync(count));
    }

    @SideOnly(value=Side.CLIENT)
    private void clientUpdateCountAsync(int count) {
        this.groupData.setPooledCount(count);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return (T)this.getGroup();
        }
        if (this.getGroup().hasCapability(capability, facing)) {
            return (T)this.getGroup().getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return true;
        }
        if (this.getGroup().hasCapability(capability, facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

