/*
 * Decompiled with CFR 0.152.
 */
package net.samtrion.compactdrawers.tile.data;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.FractionalDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.samtrion.compactdrawers.tile.TileEntityCompactDrawerBase;

public final class GroupData
extends FractionalDrawerGroup {
    @CapabilityInject(value=IDrawerAttributes.class)
    public static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;
    private final TileEntityCompactDrawerBase entity;

    public GroupData(int slotCount, TileEntityCompactDrawerBase entity) {
        super(slotCount);
        this.entity = entity;
    }

    protected World getWorld() {
        return this.entity.func_145831_w();
    }

    protected int getStackCapacity() {
        return this.entity.upgrades().getStorageMultiplier() * this.entity.getEffectiveDrawerCapacity();
    }

    protected void onItemChanged() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.entity.func_70296_d();
            this.entity.markBlockForUpdate();
        }
    }

    protected void onAmountChanged() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            BlockPos pos = this.entity.func_174877_v();
            CountUpdateMessage message = new CountUpdateMessage(pos, 0, this.getPooledCount());
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(this.getWorld().field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 500.0);
            StorageDrawers.network.sendToAllAround((IMessage)message, targetPoint);
            this.entity.func_70296_d();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == DRAWER_ATTRIBUTES_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
            return (T)this.entity.getDrawerAttributes();
        }
        return (T)super.getCapability(capability, facing);
    }
}

