/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.items;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.items.ItemCartComponent;
import vswe.stevescarts.items.ItemCartModule;
import vswe.stevescarts.items.ItemCarts;

@Mod.EventBusSubscriber(modid="stevescarts")
public final class ModItems {
    public static final Set<Item> ITEMS = new LinkedHashSet<Item>();
    public static ItemCarts CARTS = new ItemCarts();
    public static ItemCartComponent COMPONENTS = new ItemCartComponent();
    public static ItemCartModule MODULES = new ItemCartModule();

    public static void preInit() {
        ModItems.registerItem((Item)CARTS, "modularcart");
        ModItems.registerItem(COMPONENTS, "modulecomponents");
        ModItems.registerItem(MODULES, "cartmodule");
    }

    public static void registerItem(Item item, String name) {
        ITEMS.add(item);
        item.setRegistryName("stevescarts", name);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Item item : ModBlocks.ITEM_BLOCKS) {
            registry.register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS) {
            registry.register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : ITEMS) {
            StevesCarts.proxy.registerDefaultItemRenderer(item);
        }
    }

    public static void addRecipes() {
        FurnaceRecipes.func_77602_a().func_151394_a(ComponentTypes.RAW_HANDLE.getItemStack(), ComponentTypes.REFINED_HANDLE.getItemStack(), 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(ComponentTypes.RAW_HARDENER.getItemStack(), ComponentTypes.REFINED_HARDENER.getItemStack(), 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(ComponentTypes.STABILIZED_METAL.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack(), 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(ComponentTypes.LUMP_OF_GALGADOR.getItemStack(), ComponentTypes.GALGADORIAN_METAL.getItemStack(), 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(ComponentTypes.LARGE_LUMP_OF_GALGADOR.getItemStack(), ComponentTypes.ENHANCED_GALGADORIAN_METAL.getItemStack(), 0.0f);
    }

    public static interface IMultipleItemModelDefinition {
        @SideOnly(value=Side.CLIENT)
        public Map<Integer, ResourceLocation> getModels();
    }
}

