/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.workers.ModuleWorker;
import vswe.stevescarts.modules.workers.tools.ModuleFarmer;

public class ModuleHydrater
extends ModuleWorker {
    private int range = 1;

    public ModuleHydrater(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 82;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleFarmer)) continue;
            this.range = ((ModuleFarmer)module).getExternalRange();
            break;
        }
    }

    @Override
    public boolean work() {
        World world = this.getCart().field_70170_p;
        BlockPos next = this.getNextblock();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; j <= this.range; ++j) {
                if (!this.hydrate(world, next.func_177982_a(i, -1, j))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hydrate(World world, BlockPos pos) {
        int moisture;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150458_ak && (moisture = ((Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a)).intValue()) != 7) {
            int waterCost = 7 - moisture;
            waterCost = this.getCart().drain(FluidRegistry.WATER, waterCost, false);
            if (waterCost > 0) {
                if (this.doPreWork()) {
                    this.startWorking(2 + waterCost);
                    return true;
                }
                this.stopWorking();
                this.getCart().drain(FluidRegistry.WATER, waterCost, true);
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(moisture + waterCost)), 3);
            }
        }
        return false;
    }
}

