/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.config;

import com.zuxelus.comboarmors.ComboArmors;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public Configuration config;
    public boolean enableCSolars;
    public boolean enableASolars;
    public int[] soPriority = new int[4];
    public int[] stPriority = new int[4];
    public int maxProdUpgrades;
    public int maxEnergyUpgrades;
    public int maxTransferUpgrades;
    public int nanoBowBoost;
    public int turbineEUAmount;
    public int jetpackEUAmount;
    public boolean craftSolarProd;
    public boolean craftStaticProd;
    public boolean craftFlightTurbine;
    public boolean craftCloakingModule;
    public boolean craftDischargeModule;
    public boolean craftCellModule;
    public boolean craftEnergyMk2;
    public boolean craftEnergyMk3;
    public boolean useEnergyMk1;
    public boolean useOverclocker;
    public boolean useTransformer;
    public boolean craftNanoBow;
    public boolean rapidFireMode;
    public boolean spreadMode;
    public boolean sniperMode;
    public boolean flameMode;
    public boolean explosiveMode;

    public void init(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
        }
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        String CATEGORY_CROSSMOD = "cross-mod";
        String CATEGORY_GENERAL = "general";
        try {
            this.enableCSolars = this.config.getBoolean("cs-enable", "cross-mod", true, "Disable Compact Solars integration, regardless of whether or not the mod is found.", "config.cs-enable");
            this.enableASolars = this.config.getBoolean("asp-enable", "cross-mod", true, "Disabled Advanced Solar Panels integration, regardless of whether or not the mod is found.", "config.asp-enable");
            String comment = "Set the charging priority for the Solar Helmets and Static Boots. Use numbers 0-3, where 0 is the boots. Default order: 2, 0, 1, 3";
            this.soPriority[0] = this.config.getInt("solarPriority1", "general", 2, 0, 3, comment, "config.solarPriority1");
            this.soPriority[1] = this.config.getInt("solarPriority2", "general", 0, 0, 3, "", "config.solarPriority2");
            this.soPriority[2] = this.config.getInt("solarPriority3", "general", 1, 0, 3, "", "config.solarPriority3");
            this.soPriority[3] = this.config.getInt("solarPriority4", "general", 3, 0, 3, "", "config.solarPriority4");
            this.stPriority[0] = this.config.getInt("staticPriority1", "general", 2, 0, 3, "", "config.staticPriority1");
            this.stPriority[1] = this.config.getInt("staticPriority2", "general", 0, 0, 3, "", "config.staticPriority2");
            this.stPriority[2] = this.config.getInt("staticPriority3", "general", 1, 0, 3, "", "config.staticPriority3");
            this.stPriority[3] = this.config.getInt("staticPriority4", "general", 3, 0, 3, "", "config.staticPriority4");
            this.turbineEUAmount = this.config.getInt("euUsageTurbine", "general", 10, 0, 10000, "", "config.euUsageTurbine");
            this.jetpackEUAmount = this.config.getInt("euUsageJetpack", "general", 8, 0, 10000, "Change the EU Usage of Jetpacks and Turbines. Hover mode uses 25% less than the value below.", "config.euUsageJetpack");
            this.maxProdUpgrades = this.config.getInt("maxProductionUpgrades", "general", 511, 0, 65530, "Set the max number of Solar Production or Static Production upgrades to be installed in one item. Note that the max will be one more than the number you enter, as the default has 1. Default value: 511.", "config.maxProductionUpgrades");
            this.maxEnergyUpgrades = this.config.getInt("maxEnergyUpgrades", "general", 100000000, 0, Integer.MAX_VALUE, "Set the max Energy that an upgraded item can have. Default: 100,000,000", "config.maxEnergyUpgrades");
            this.maxTransferUpgrades = this.config.getInt("maxTransferUpgrades", "general", 200000, 0, 10000000, "Set the max Transfer Limit that an upgraded item can have. Default: 200,000", "config.maxTransferUpgrades");
            comment = "Enable whether or not the upgrades can be crafted. They can still be spawned in and used if you are an admin. Default: true.";
            this.craftCellModule = this.config.getBoolean("enableCraftingCellModule", "general", true, comment, "config.enableCraftingCellModule");
            this.craftSolarProd = this.config.getBoolean("enableCraftingSolarProduction", "general", true, "", "config.enableCraftingSolarProduction");
            this.craftStaticProd = this.config.getBoolean("enableCraftingStaticProduction", "general", true, "", "config.enableCraftingStaticProduction");
            this.craftFlightTurbine = this.config.getBoolean("enableCraftingFlightTurbine", "general", true, "", "config.enableCraftingFlightTurbine");
            this.craftCloakingModule = this.config.getBoolean("enableCraftingCloakingModule", "general", true, "", "config.enableCraftingCloakingModule");
            this.craftDischargeModule = this.config.getBoolean("enableCraftingDischargeModule", "general", true, "", "config.enableCraftingDischargeModule");
            this.craftEnergyMk2 = this.config.getBoolean("enableCraftingEnergyMk2", "general", true, "", "config.enableCraftingEnergyMk2");
            this.craftEnergyMk3 = this.config.getBoolean("enableCraftingEnergyMk3", "general", true, "", "config.enableCraftingEnergyMk3");
            this.craftNanoBow = this.config.getBoolean("enableCraftingNanoBow", "general", true, "", "config.enableCraftingNanoBow");
            this.useEnergyMk1 = this.config.getBoolean("enableUseEnergyMk1", "general", true, "", "config.enableUseEnergyMk1");
            this.useOverclocker = this.config.getBoolean("enableUseOverclocker", "general", true, "", "config.enableUseOverclocker");
            this.useTransformer = this.config.getBoolean("enableUseTransformer", "general", true, "", "config.enableUseTransformer");
            this.nanoBowBoost = this.config.getInt("nanoBowDamageBoost", "general", 0, 0, 10000, "Boost the damage of the NanoBow, for use with things like Divine RPG. Each number adds 1 level of the Power enchantment.", "config.nanoBowDamageBoost");
            comment = "Enabled NanoBow modes { \"Normal\", \"Rapid fire\", \"Spread\", \"Sniper\", \"Flame\", \"Explosive\" }";
            this.explosiveMode = this.config.getBoolean("bowExplosiveMode", "general", true, comment, "config.bowExplosiveMode");
            this.flameMode = this.config.getBoolean("bowFlameMode", "general", true, "", "config.bowFlameMode");
            this.rapidFireMode = this.config.getBoolean("bowRapidFireMode", "general", true, "", "config.bowRapidFireMode");
            this.sniperMode = this.config.getBoolean("bowSniperMode", "general", true, "", "config.bowSniperMode");
            this.spreadMode = this.config.getBoolean("bowSpreadMode", "general", true, "", "config.bowSpreadMode");
        }
        catch (Exception e) {
            ComboArmors.logger.error("Mod has a problem loading it's configuration", (Throwable)e);
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("comboarmors")) {
            this.loadConfig();
        }
    }
}

