/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items.armor;

import com.zuxelus.comboarmors.items.armor.ItemArmorElectricUtility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBootsStaticQuantum
extends ItemArmorElectricUtility
implements IMetalArmor {
    public ItemBootsStaticQuantum() {
        super(EntityEquipmentSlot.FEET, 10000000, 12000, 4, false);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "comboarmors:textures/armor/quantum_static.png";
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 1.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 20000;
    }

    @Override
    public int getItemTier() {
        return 4;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return super.getProperties(entity, armor, source, damage, slot);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public boolean isMetalArmor(ItemStack stack, EntityPlayer player) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        boolean updated = false;
        if (ItemBootsStaticQuantum.doStatic(player, stack)) {
            updated = true;
        }
        if (this.onQuantumBootsTick(player, stack)) {
            updated = true;
        }
        if (updated) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        this.onFall(event, true);
    }
}

