/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.jei;

import com.zuxelus.comboarmors.gui.GuiArmorAssembler;
import com.zuxelus.comboarmors.init.ModItems;
import com.zuxelus.comboarmors.recipes.ArmorAssemblerRecipes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@JEIPlugin
public class JEIModPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ArmorAssemblerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void register(IModRegistry registry) {
        registry.addRecipes(ArmorAssemblerRecipes.getRecipeList(), "comboarmors:armor_assembler");
        registry.handleRecipes(ArmorAssemblerRecipes.Recipe.class, recipe -> new ArmorAssemblerRecipeWrapper((ArmorAssemblerRecipes.Recipe)recipe), "comboarmors:armor_assembler");
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.armorAssembler), new String[]{"comboarmors:armor_assembler"});
        registry.addRecipeClickArea(GuiArmorAssembler.class, 79, 34, 22, 15, new String[]{"comboarmors:armor_assembler"});
    }

    public class ArmorAssemblerRecipeWrapper
    implements IRecipeWrapper {
        private List<ItemStack> inputs;
        private ItemStack output;

        public ArmorAssemblerRecipeWrapper(ArmorAssemblerRecipes.Recipe recipe) {
            this.inputs = Arrays.asList(recipe.input1, recipe.input2);
            this.output = recipe.output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(ItemStack.class, Collections.singletonList(this.inputs));
            ingredients.setOutput(ItemStack.class, (Object)this.output);
        }

        public List<ItemStack> getInputs() {
            return this.inputs;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }

    public class ArmorAssemblerRecipeCategory
    implements IRecipeCategory<ArmorAssemblerRecipeWrapper> {
        public static final String UID = "comboarmors:armor_assembler";
        private final IDrawable background;

        public ArmorAssemblerRecipeCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("comboarmors", "textures/gui/gui_armor_assembler.png"), 36, 12, 135, 62);
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public String getModName() {
            return "comboarmors";
        }

        public String getTitle() {
            return I18n.func_135052_a((String)"tile.armor_assembler.name", (Object[])new Object[0]);
        }

        public String getUid() {
            return UID;
        }

        public void drawExtras(Minecraft mc) {
        }

        public void setRecipe(IRecipeLayout layout, ArmorAssemblerRecipeWrapper recipes, IIngredients ingredients) {
            List<ItemStack> inputs = recipes.getInputs();
            IGuiItemStackGroup isg = layout.getItemStacks();
            isg.init(0, true, 5, 4);
            isg.set(0, inputs.get(0));
            isg.init(1, true, 31, 4);
            isg.set(1, inputs.get(1));
            isg.init(2, false, 85, 22);
            isg.set(2, recipes.getOutput());
        }
    }
}

