/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common.tiles;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.xalcon.energyconverters.common.EnergyConvertersConfig;

public class TileEntityEnergyBridge
extends TileEntity {
    private double energyStored;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energyStored = compound.func_74769_h("energy");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74780_a("energy", this.energyStored);
        return super.func_189515_b(compound);
    }

    public double addEnergy(double amountIn, boolean simulate) {
        double lossRate = 1.0 - EnergyConvertersConfig.conversionLoss / 100.0;
        double amount = amountIn * lossRate;
        double maxBuffer = EnergyConvertersConfig.bridgeEnergyBuffer;
        if (amount + this.energyStored > maxBuffer) {
            amount = maxBuffer - this.energyStored;
        }
        if (!simulate) {
            this.energyStored += amount;
        }
        return amount / lossRate;
    }

    public double getEnergy(double maxAmount, boolean simulate) {
        double amount = maxAmount;
        if (this.energyStored - amount < 0.0) {
            amount = this.energyStored;
        }
        if (!simulate) {
            this.energyStored -= amount;
        }
        return amount;
    }

    public double getStoredEnergy() {
        return this.energyStored;
    }

    public double getStoredEnergyMax() {
        return EnergyConvertersConfig.bridgeEnergyBuffer;
    }
}

