/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.BlockIEMultiblock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cappcraft.immersivechemical.ImmersiveChemicalEngineering;
import team.cappcraft.immersivechemical.common.blocks.multiblocks.BlockTypes_HeatExchanger;
import team.cappcraft.immersivechemical.common.proxy.CommonProxy;
import team.cappcraft.immersivechemical.common.tileentity.TileHeatExchangerLarge;
import team.cappcraft.immersivechemical.common.tileentity.TileHeatExchangerMedium;
import team.cappcraft.immersivechemical.common.tileentity.TileHeatExchangerSmall;

public class BlockHeatExchanger
extends BlockIEMultiblock<BlockTypes_HeatExchanger> {
    public BlockHeatExchanger() {
        super("multiblock_heat_exchanger", Material.field_151573_f, PropertyEnum.func_177709_a((String)"type", BlockTypes_HeatExchanger.class), ItemBlockIEBase.class, new Object[]{IEProperties.BOOLEANS[0]});
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.setAllNotNormalBlock();
        this.func_149647_a(ImmersiveChemicalEngineering.creativeTab);
        this.field_149786_r = 0;
    }

    @Nonnull
    public String createRegistryName() {
        return "immersivechemical:" + this.name;
    }

    public boolean useCustomStateMapper() {
        return true;
    }

    @Nonnull
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        switch (meta) {
            case 0: {
                return "small";
            }
            case 1: {
                return "medium";
            }
            case 2: {
                return "large";
            }
        }
        throw new IllegalArgumentException(String.format("Unknown meta:%d", meta));
    }

    public boolean func_180639_a(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IGuiTile && hand == EnumHand.MAIN_HAND && !player.func_70093_af()) {
            TileEntity master = ((IEBlockInterfaces.IGuiTile)tile).getGuiMaster();
            if (!world.field_72995_K && master != null && ((IEBlockInterfaces.IGuiTile)master).canOpenGui(player)) {
                CommonProxy.openGuiForTile(player, (TileEntity)((IEBlockInterfaces.IGuiTile)master));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Nullable
    public TileEntity createBasicTE(@Nonnull World worldIn, @Nonnull BlockTypes_HeatExchanger type) {
        switch (type) {
            case HEAT_EXCHANGER_SMALL: {
                return new TileHeatExchangerSmall();
            }
            case HEAT_EXCHANGER_MEDIUM: {
                return new TileHeatExchangerMedium();
            }
            case HEAT_EXCHANGER_LARGE: {
                return new TileHeatExchangerLarge();
            }
        }
        return null;
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public boolean allowHammerHarvest(@Nonnull IBlockState blockState) {
        return true;
    }
}

