/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.compact.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.Objects;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import team.cappcraft.immersivechemical.common.recipe.ConvertDirection;
import team.cappcraft.immersivechemical.common.recipe.HeatExchangerEntry;
import team.cappcraft.immersivechemical.common.recipe.HeatExchangerRegistry;

@ZenClass(value="team.cappcraft.icheme.HeatExchanger")
@ZenRegister
public class HeatExchangerCTRecipe {
    @ZenMethod
    public static void addCoolDownEntry(ILiquidStack in, ILiquidStack out, int heat) {
        CraftTweakerAPI.apply((IAction)new AddHeatExchangerEntryAction(in, out, heat, ConvertDirection.COOL_DOWN));
    }

    @ZenMethod
    public static void addHeatUpEntry(ILiquidStack in, ILiquidStack out, int heat) {
        CraftTweakerAPI.apply((IAction)new AddHeatExchangerEntryAction(in, out, heat, ConvertDirection.HEAT_UP));
    }

    @ZenMethod
    public static void addBiDirectionEntry(ILiquidStack in, ILiquidStack out, int heat) {
        CraftTweakerAPI.apply((IAction)new AddHeatExchangerEntryAction(in, out, heat, ConvertDirection.TWO_WAY));
    }

    private static class AddHeatExchangerEntryAction
    implements IAction {
        private final ILiquidStack In;
        private final ILiquidStack Out;
        private final int Heat;
        private final ConvertDirection Direction;
        private String describeInvalid;
        private HeatExchangerEntry entry;

        public AddHeatExchangerEntryAction(ILiquidStack in, ILiquidStack out, int heat, ConvertDirection direction) {
            this.In = in;
            this.Out = out;
            this.Heat = heat;
            this.Direction = direction;
        }

        public void apply() {
            this.entry = new HeatExchangerEntry(Objects.requireNonNull(FluidRegistry.getFluidStack((String)this.In.getName(), (int)this.In.getAmount())), Objects.requireNonNull(FluidRegistry.getFluidStack((String)this.Out.getName(), (int)this.Out.getAmount())), this.Heat, this.Direction);
            HeatExchangerRegistry.REGISTRY.registerFluid(this.entry);
        }

        public String describe() {
            return String.format("Added %s", this.entry);
        }

        public boolean validate() {
            if (FluidRegistry.getFluid((String)this.In.getName()) == null || FluidRegistry.getFluid((String)this.Out.getName()) == null) {
                this.describeInvalid = "Input/Output Fluid isn't registered in FluidRegistry";
            }
            if (this.Heat <= 0) {
                this.describeInvalid = "Heat value <= 0";
            }
            return this.describeInvalid == null;
        }

        public String describeInvalid() {
            return this.describeInvalid;
        }
    }
}

