/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.compact.jei;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;
import team.cappcraft.immersivechemical.common.compact.jei.HeatExchangerRecipeCategory;
import team.cappcraft.immersivechemical.common.compact.jei.JEIPlugin;
import team.cappcraft.immersivechemical.common.recipe.ConvertDirection;
import team.cappcraft.immersivechemical.common.recipe.HeatExchangerEntry;

public class HeatExchangerRecipeWrapper
implements IRecipeWrapper {
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int ICON_X = 135;
    private static final int ICON_WIDTH = 15;
    private static final int ICON_HEIGHT = 5;
    private static final int ICON_HOT_Y = 6;
    private static final int ICON_DRAW_X = 59;
    private static final int ICON_DRAW_Y_COLD = 25;
    private static final int ICON_DRAW_Y_HOT = 34;
    private static final IDrawableStatic COLD_ICON = JEIPlugin.guiHelper.createDrawable(HeatExchangerRecipeCategory.resourceLocation, 135, 0, 15, 5);
    private static final IDrawableStatic HOT_ICON = JEIPlugin.guiHelper.createDrawable(HeatExchangerRecipeCategory.resourceLocation, 135, 6, 15, 5);
    public final int MinCapacity;
    public final HeatExchangerEntry Entry;

    public HeatExchangerRecipeWrapper(HeatExchangerEntry Entry2) {
        this.Entry = Entry2;
        this.MinCapacity = Math.max(Entry2.FluidHot.amount, Entry2.FluidCold.amount);
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        if (this.Entry.Direction == ConvertDirection.HEAT_UP) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)this.Entry.FluidCold);
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.Entry.FluidHot);
        } else if (this.Entry.Direction == ConvertDirection.COOL_DOWN) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)this.Entry.FluidHot);
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.Entry.FluidCold);
        } else {
            ingredients.setInputs(VanillaTypes.FLUID, (List)Lists.newArrayList((Object[])new FluidStack[]{this.Entry.FluidHot, this.Entry.FluidCold}));
            ingredients.setOutputs(VanillaTypes.FLUID, (List)Lists.newArrayList((Object[])new FluidStack[]{this.Entry.FluidCold, this.Entry.FluidHot}));
        }
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78276_b(String.format("Heat: %d", this.Entry.HeatValue), 20, 56, 0xFFFFFF);
        if (this.Entry.Direction == ConvertDirection.COOL_DOWN || this.Entry.Direction == ConvertDirection.TWO_WAY) {
            COLD_ICON.draw(minecraft, 59, 25);
        }
        if (this.Entry.Direction == ConvertDirection.HEAT_UP || this.Entry.Direction == ConvertDirection.TWO_WAY) {
            HOT_ICON.draw(minecraft, 60, 34);
        }
    }
}

