/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.recipe;

import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import team.cappcraft.immersivechemical.common.recipe.ConvertDirection;

public class HeatExchangerEntry
implements IJEIRecipe {
    @Nonnull
    public final FluidStack FluidHot;
    @Nonnull
    public final FluidStack FluidCold;
    public final int HeatValue;
    public final ConvertDirection Direction;

    public HeatExchangerEntry(@Nonnull FluidStack fluidA, @Nonnull FluidStack fluidB, int heatValue) {
        this(fluidA, fluidB, heatValue, ConvertDirection.TWO_WAY);
    }

    public HeatExchangerEntry(@Nonnull FluidStack fluidA, @Nonnull FluidStack fluidB, int heatValue, ConvertDirection direction) {
        if (fluidA.getFluid().getTemperature() > fluidB.getFluid().getTemperature()) {
            this.FluidHot = fluidA;
            this.FluidCold = fluidB;
        } else {
            this.FluidHot = fluidB;
            this.FluidCold = fluidA;
        }
        this.HeatValue = heatValue;
        this.Direction = direction;
    }

    public String toString() {
        return "HeatExchangerRecipeEntry{FluidHot=" + this.FluidHot + ", FluidCold=" + this.FluidCold + ", HeatValue=" + this.HeatValue + ", Direction=" + (Object)((Object)this.Direction) + '}';
    }

    public boolean isInputMatches(@Nonnull FluidTank fluidTank, ConvertDirection direction) {
        return this.isInputMatches(fluidTank.getFluid(), direction);
    }

    public boolean isInputMatches(@Nullable FluidStack fluidStack, ConvertDirection direction) {
        return fluidStack != null && this.isInputMatches(fluidStack.getFluid(), direction);
    }

    public boolean isInputMatches(@Nonnull Fluid fluid, ConvertDirection direction) {
        return fluid == this.getInput(direction).getFluid();
    }

    public boolean isOutputMatches(@Nonnull FluidTank fluidTank, ConvertDirection direction) {
        return this.isOutputMatches(fluidTank.getFluid(), direction);
    }

    public boolean isOutputMatches(@Nullable FluidStack fluidStack, ConvertDirection direction) {
        return fluidStack != null && this.isOutputMatches(fluidStack.getFluid(), direction);
    }

    public boolean isOutputMatches(@Nonnull Fluid fluid, ConvertDirection direction) {
        return fluid == this.getOutput(direction).getFluid();
    }

    public FluidStack getInput(ConvertDirection direction) {
        switch (direction) {
            case COOL_DOWN: {
                return this.FluidHot;
            }
            case HEAT_UP: {
                return this.FluidCold;
            }
        }
        throw new IllegalArgumentException("Invalid direction:" + (Object)((Object)direction));
    }

    public FluidStack getOutput(ConvertDirection direction) {
        switch (direction) {
            case COOL_DOWN: {
                return this.FluidCold;
            }
            case HEAT_UP: {
                return this.FluidHot;
            }
        }
        throw new IllegalArgumentException("Invalid direction:" + (Object)((Object)direction));
    }

    public List<ItemStack> getJEITotalItemInputs() {
        return Collections.emptyList();
    }

    public List<ItemStack> getJEITotalItemOutputs() {
        return Collections.emptyList();
    }

    public List<FluidStack> getJEITotalFluidInputs() {
        return this.Direction == ConvertDirection.TWO_WAY ? Arrays.asList(this.FluidHot, this.FluidCold) : Collections.singletonList(this.FluidHot);
    }

    public List<FluidStack> getJEITotalFluidOutputs() {
        return this.Direction == ConvertDirection.TWO_WAY ? Arrays.asList(this.FluidHot, this.FluidCold) : Collections.singletonList(this.FluidCold);
    }
}

