/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.recipe;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import team.cappcraft.immersivechemical.common.recipe.ConvertDirection;
import team.cappcraft.immersivechemical.common.recipe.HeatExchangerEntry;
import team.cappcraft.immersivechemical.common.recipe.HeatExchangerRecipe;
import team.cappcraft.immersivechemical.common.tileentity.IHeatExchangerProperties;
import team.cappcraft.jgrapht.Graph;
import team.cappcraft.jgrapht.GraphPath;
import team.cappcraft.jgrapht.alg.shortestpath.DijkstraShortestPath;
import team.cappcraft.jgrapht.graph.SimpleDirectedWeightedGraph;
import team.cappcraft.jgrapht.traverse.DepthFirstIterator;

public class HeatExchangerRegistry {
    public static final HeatExchangerRegistry REGISTRY = new HeatExchangerRegistry();
    public final ExecutorService RecipeFinder = Executors.newSingleThreadExecutor();
    private final HashMap<IHeatExchangerProperties, ItemStack> registeredHeatExchanger = new LinkedHashMap<IHeatExchangerProperties, ItemStack>();
    private final HashSet<HeatExchangerEntry> registeredEntries = new HashSet();
    private final SimpleDirectedWeightedGraph<Fluid, WeakReference<HeatExchangerEntry>> COOL_DOWN_FluidGraph = new SimpleDirectedWeightedGraph(null, null);
    private final SimpleDirectedWeightedGraph<Fluid, WeakReference<HeatExchangerEntry>> HEAT_UP_FluidGraph = new SimpleDirectedWeightedGraph(null, null);
    private final HashSet<WeakReference<HeatExchangerEntry>> generatedEntries = new HashSet();

    public void registerHeatExchanger(IHeatExchangerProperties properties, ItemStack renderStack) {
        this.registeredHeatExchanger.put(properties, renderStack);
    }

    public void registerFluid(HeatExchangerEntry entry) {
        this.registeredEntries.add(entry);
        this.insertEntryAsEdge(entry, 1, false);
    }

    public Set<HeatExchangerEntry> getRegisteredEntries() {
        return Collections.unmodifiableSet(this.registeredEntries);
    }

    public Map<IHeatExchangerProperties, ItemStack> getRegisteredHeatExchanger() {
        return Collections.unmodifiableMap(this.registeredHeatExchanger);
    }

    public Optional<HeatExchangerRecipe> findRecipe(IFluidTank inputA, IFluidTank inputB, IFluidTank outputA, IFluidTank outputB) {
        Optional<Fluid> FarthestOA;
        Optional<Fluid> FarthestOB;
        Fluid FluidOB;
        Fluid FluidIA = inputA.getFluid() == null ? null : inputA.getFluid().getFluid();
        Fluid FluidIB = inputB.getFluid() == null ? null : inputB.getFluid().getFluid();
        Fluid FluidOA = outputA.getFluid() == null ? null : outputA.getFluid().getFluid();
        Fluid fluid = FluidOB = outputB.getFluid() == null ? null : outputB.getFluid().getFluid();
        if (FluidIA == null || FluidIB == null || FluidIA.getTemperature() == FluidIB.getTemperature()) {
            return Optional.empty();
        }
        if (FluidOA != null && FluidOB != null && (FluidIA.getTemperature() > FluidIB.getTemperature() && FluidOA.getTemperature() < FluidOB.getTemperature() || FluidIA.getTemperature() < FluidIB.getTemperature() && FluidOA.getTemperature() > FluidOB.getTemperature())) {
            return Optional.empty();
        }
        ConvertDirection DirectionA = FluidIA.getTemperature() > FluidIB.getTemperature() ? ConvertDirection.COOL_DOWN : ConvertDirection.HEAT_UP;
        ConvertDirection DirectionB = DirectionA.getOpposite();
        if (!this.getFluidGraph(DirectionA).containsVertex(FluidIA) || !this.getFluidGraph(DirectionB).containsVertex(FluidIB)) {
            return Optional.empty();
        }
        if (FluidOA != null && FluidOB != null) {
            return this.getHeatExchangerRecipe(FluidIA, FluidIB, FluidOA, FluidOB, DirectionA, DirectionB);
        }
        if (FluidOA != null && (FarthestOB = this.findFarthest(FluidIB, DirectionB, FluidOA.getTemperature())).isPresent()) {
            return this.getHeatExchangerRecipe(FluidIA, FluidIB, FluidOA, FarthestOB.get(), DirectionA, DirectionB);
        }
        if (FluidOA == null && FluidOB != null && (FarthestOA = this.findFarthest(FluidIA, DirectionA, FluidOB.getTemperature())).isPresent()) {
            return this.getHeatExchangerRecipe(FluidIA, FluidIB, FarthestOA.get(), FluidOB, DirectionA, DirectionB);
        }
        if (FluidOA == null && FluidOB == null) {
            Optional<Fluid> FarthestOB2;
            Optional<Fluid> NextOA;
            Optional<Fluid> optional = NextOA = DirectionA == ConvertDirection.COOL_DOWN ? this.findReachable(FluidIA, DirectionA).parallelStream().max(Comparator.comparingInt(Fluid::getTemperature)) : this.findReachable(FluidIA, DirectionA).parallelStream().min(Comparator.comparingInt(Fluid::getTemperature));
            if (NextOA.isPresent() && (FarthestOB2 = this.findFarthest(FluidIB, DirectionB, NextOA.get().getTemperature())).isPresent()) {
                return this.getHeatExchangerRecipe(FluidIA, FluidIB, NextOA.get(), FarthestOB2.get(), DirectionA, DirectionB);
            }
        }
        return Optional.empty();
    }

    public Optional<HeatExchangerRecipe> getHeatExchangerRecipe(Fluid FluidIA, Fluid FluidIB, Fluid FluidOA, Fluid FluidOB, ConvertDirection DirectionA, ConvertDirection DirectionB) {
        Optional<HeatExchangerEntry> EntryA = this.findOrGenerateEntry(FluidIA, FluidOA, DirectionA);
        Optional<HeatExchangerEntry> EntryB = this.findOrGenerateEntry(FluidIB, FluidOB, DirectionB);
        if (EntryA.isPresent() && EntryB.isPresent()) {
            return Optional.of(new HeatExchangerRecipe(EntryA.get(), EntryB.get(), DirectionA, DirectionB));
        }
        return Optional.empty();
    }

    public Optional<Fluid> findFarthest(@Nonnull Fluid input, ConvertDirection direction, int tempLimit) {
        if (direction == ConvertDirection.COOL_DOWN) {
            return this.findReachable(input, direction).parallelStream().filter(fluid -> fluid.getTemperature() >= tempLimit).min(Comparator.comparingInt(Fluid::getTemperature));
        }
        return this.findReachable(input, direction).parallelStream().filter(fluid -> fluid.getTemperature() <= tempLimit).max(Comparator.comparingInt(Fluid::getTemperature));
    }

    public List<Fluid> findReachable(@Nonnull Fluid input, ConvertDirection direction) {
        DepthFirstIterator<Fluid, WeakReference<HeatExchangerEntry>> iter = new DepthFirstIterator<Fluid, WeakReference<HeatExchangerEntry>>(this.getFluidGraph(direction), input);
        LinkedList<Fluid> fluids = new LinkedList<Fluid>();
        while (iter.hasNext()) {
            fluids.add((Fluid)iter.next());
        }
        fluids.removeFirst();
        return fluids;
    }

    public Optional<HeatExchangerEntry> findOrGenerateEntry(@Nonnull Fluid input, @Nonnull Fluid output, ConvertDirection direction) {
        Graph<Fluid, WeakReference<HeatExchangerEntry>> graph = this.getFluidGraph(direction);
        Optional<HeatExchangerEntry> StrongConnected = this.findEntry(input, output, graph);
        if (!StrongConnected.isPresent()) {
            List<HeatExchangerEntry> refEntry = this.cleanAndRefEntry();
            GraphPath<Fluid, WeakReference<HeatExchangerEntry>> path = new DijkstraShortestPath<Fluid, WeakReference<HeatExchangerEntry>>(graph).getPath(input, output);
            if (path != null) {
                int TotalHeat = path.getEdgeList().parallelStream().mapToInt(value -> ((HeatExchangerEntry)Objects.requireNonNull(value.get())).HeatValue).sum();
                FluidStack FluidStackInput = ((HeatExchangerEntry)Objects.requireNonNull(path.getEdgeList().get(0).get())).getInput(direction);
                FluidStack FluidStackOutput = ((HeatExchangerEntry)Objects.requireNonNull(path.getEdgeList().get(path.getLength() - 1).get())).getOutput(direction);
                HeatExchangerEntry generatedEntry = new HeatExchangerEntry(FluidStackInput, FluidStackOutput, TotalHeat, direction);
                this.insertEntryAsEdge(generatedEntry, path.getLength(), true);
                return Optional.of(generatedEntry);
            }
        }
        return StrongConnected;
    }

    public Graph<Fluid, WeakReference<HeatExchangerEntry>> getFluidGraph(ConvertDirection direction) {
        return direction == ConvertDirection.COOL_DOWN ? this.COOL_DOWN_FluidGraph : this.HEAT_UP_FluidGraph;
    }

    public void insertEntryAsEdge(HeatExchangerEntry entry, int weight, boolean generated) {
        Fluid Hot = entry.FluidHot.getFluid();
        Fluid Cold = entry.FluidCold.getFluid();
        WeakReference<HeatExchangerEntry> ref = new WeakReference<HeatExchangerEntry>(entry);
        if (generated) {
            this.generatedEntries.add(ref);
        }
        if (entry.Direction == ConvertDirection.COOL_DOWN || entry.Direction == ConvertDirection.TWO_WAY) {
            this.COOL_DOWN_FluidGraph.addVertex(Hot);
            this.COOL_DOWN_FluidGraph.addVertex(Cold);
            this.COOL_DOWN_FluidGraph.addEdge(Hot, Cold, ref);
            this.COOL_DOWN_FluidGraph.setEdgeWeight(ref, weight);
        }
        if (entry.Direction == ConvertDirection.HEAT_UP || entry.Direction == ConvertDirection.TWO_WAY) {
            this.HEAT_UP_FluidGraph.addVertex(Hot);
            this.HEAT_UP_FluidGraph.addVertex(Cold);
            this.HEAT_UP_FluidGraph.addEdge(Cold, Hot, ref);
            this.HEAT_UP_FluidGraph.setEdgeWeight(ref, weight);
        }
    }

    public List<HeatExchangerEntry> cleanAndRefEntry() {
        List<HeatExchangerEntry> result = this.generatedEntries.parallelStream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toList());
        Collection nullRefs = this.generatedEntries.parallelStream().filter(edge -> edge.get() == null).collect(Collectors.toList());
        this.COOL_DOWN_FluidGraph.removeAllEdges(nullRefs);
        this.HEAT_UP_FluidGraph.removeAllEdges(nullRefs);
        this.generatedEntries.removeAll(nullRefs);
        return result;
    }

    public Optional<HeatExchangerEntry> findEntry(@Nonnull Fluid input, @Nonnull Fluid output, Graph<Fluid, WeakReference<HeatExchangerEntry>> graph) {
        WeakReference<HeatExchangerEntry> edge = graph.getEdge(input, output);
        if (edge == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(edge.get());
    }
}

