/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.tileentity;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import team.cappcraft.immersivechemical.ImmersiveChemicalEngineering;
import team.cappcraft.immersivechemical.common.recipe.ConvertDirection;
import team.cappcraft.immersivechemical.common.recipe.HeatExchangerEntry;
import team.cappcraft.immersivechemical.common.recipe.HeatExchangerRecipe;
import team.cappcraft.immersivechemical.common.recipe.HeatExchangerRegistry;
import team.cappcraft.immersivechemical.common.tileentity.IHeatExchangerProperties;
import team.cappcraft.immersivechemical.common.tileentity.ILockableSlot;
import team.cappcraft.immersivechemical.common.tileentity.ITickableStateMachine;
import team.cappcraft.immersivechemical.common.tileentity.LockableFluidTank;

public abstract class AbstractTileHeatExchanger
extends TileEntityMultiblockPart<AbstractTileHeatExchanger>
implements IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IProcessTile,
IEBlockInterfaces.IMirrorAble,
IEBlockInterfaces.IComparatorOverride {
    public static final String TAG_TANKS = "Tanks";
    public static final String TAG_PROCESSING = "Processing";
    public static final String TAG_STATE = "State";
    public static final String TAG_IDLE_TIME = "IdleTime";
    public static final String TAG_CACHED_HEAT = "Cached_Heat";
    public final int CoolDownBase = 200;
    public final IHeatExchangerProperties Properties;
    public final LockableFluidTank[] Tanks;
    @Nonnull
    public ITickableStateMachine<AbstractTileHeatExchanger> currentState = TileHeatExchangerTickAction.DecideRecipe.IS_INPUT_READY_FOR_MATCH;
    public int idleTime = 0;
    protected HeatExchangerRecipe cachedRecipe;
    protected int coolDown;
    protected int cachedHeat;
    protected int tickSinceLastExchange;
    protected int tickRequired;

    public AbstractTileHeatExchanger(int[] structureDimensions, IHeatExchangerProperties properties) {
        super(structureDimensions);
        this.Properties = properties;
        int Capacity = this.Properties.getCapacity();
        this.Tanks = new LockableFluidTank[]{new LockableFluidTank(Capacity, this::onInputSlotChanged), new LockableFluidTank(Capacity, this::onOutputSlotChanged), new LockableFluidTank(Capacity, this::onInputSlotChanged), new LockableFluidTank(Capacity, this::onOutputSlotChanged)};
        for (int i = 0; i < this.Tanks.length; ++i) {
            LockableFluidTank tank = this.Tanks[i];
            tank.setTileEntity((TileEntity)this);
            tank.setCanFill(i % 2 == 0);
            tank.setCanDrain(i % 2 != 0);
        }
    }

    @Nonnull
    protected abstract IFluidTank[] getAccessibleFluidTanks(@Nonnull EnumFacing var1);

    protected abstract boolean canFillTankFrom(int var1, @Nonnull EnumFacing var2, @Nonnull FluidStack var3);

    protected abstract boolean canDrainTankFrom(int var1, @Nonnull EnumFacing var2);

    @Nonnull
    public abstract ItemStack getOriginalBlock();

    @Nonnull
    public abstract float[] getBlockBounds();

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking((TileEntity)this);
        if (this.isDummy() || this.field_145850_b.field_72995_K) {
            return;
        }
        ITickableStateMachine<AbstractTileHeatExchanger> newState = this.currentState.nextState(this);
        if (this.currentState != newState) {
            this.markContainingBlockForUpdate(null);
        }
        this.currentState = newState;
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        NBTTagList tanks = nbt.func_150295_c(TAG_TANKS, 10);
        for (int i = 0; i < tanks.func_74745_c(); ++i) {
            LockableFluidTank tank = this.Tanks[i];
            tank.readFromNBT(tanks.func_150305_b(i));
        }
        this.idleTime = nbt.func_74762_e(TAG_IDLE_TIME);
        this.cachedHeat = nbt.func_74762_e(TAG_CACHED_HEAT);
        if (descPacket) {
            this.currentState = nbt.func_74767_n(TAG_PROCESSING) ? TileHeatExchangerTickAction.Processing.values()[nbt.func_74762_e(TAG_STATE)] : TileHeatExchangerTickAction.DecideRecipe.values()[nbt.func_74762_e(TAG_STATE)];
        }
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        NBTTagList tanks = new NBTTagList();
        for (LockableFluidTank tank : this.Tanks) {
            tanks.func_74742_a((NBTBase)tank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a(TAG_TANKS, (NBTBase)tanks);
        nbt.func_74768_a(TAG_IDLE_TIME, this.idleTime);
        nbt.func_74768_a(TAG_CACHED_HEAT, this.cachedHeat);
        if (descPacket) {
            nbt.func_74757_a(TAG_PROCESSING, this.currentState instanceof TileHeatExchangerTickAction.Processing);
            nbt.func_74768_a(TAG_STATE, ((Enum)((Object)this.currentState)).ordinal());
        }
    }

    @Nonnull
    public IEProperties.PropertyBoolInverted getBoolProperty(@Nonnull Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    public boolean getIsMirrored() {
        return this.mirrored;
    }

    @Nonnull
    public int[] getCurrentProcessesStep() {
        AbstractTileHeatExchanger master = (AbstractTileHeatExchanger)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.tickSinceLastExchange};
    }

    @Nonnull
    public int[] getCurrentProcessesMax() {
        AbstractTileHeatExchanger master = (AbstractTileHeatExchanger)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.currentState instanceof TileHeatExchangerTickAction.Processing ? this.tickRequired : 0};
    }

    public boolean canOpenGui() {
        return this.formed;
    }

    public int getGuiID() {
        return 0;
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    protected void onInputSlotChanged(FluidEvent event) {
        if (event instanceof FluidEvent.FluidFillingEvent) {
            if (this.currentState == TileHeatExchangerTickAction.DecideRecipe.WAITING_INPUT_SLOT_CHANGE) {
                this.coolDown = 100;
                this.currentState = TileHeatExchangerTickAction.DecideRecipe.MATCH_COOL_DOWN;
            }
            ((ILockableSlot)((FluidEvent.FluidFillingEvent)event).getTank()).setLockedType(true);
        }
    }

    protected void onOutputSlotChanged(FluidEvent event) {
        if (event instanceof FluidEvent.FluidFillingEvent) {
            ((ILockableSlot)((FluidEvent.FluidFillingEvent)event).getTank()).setLockedType(true);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (!super.func_145842_c(id, type)) {
            switch (id) {
                case 1: {
                    this.clearFluidSlot(0);
                    this.clearFluidSlot(1);
                    return true;
                }
                case 2: {
                    this.clearFluidSlot(2);
                    this.clearFluidSlot(3);
                    return true;
                }
                case 3: {
                    this.clearFluidSlot(0);
                    this.clearFluidSlot(1);
                    this.clearFluidSlot(2);
                    this.clearFluidSlot(3);
                    return true;
                }
            }
        }
        return false;
    }

    protected void clearFluidSlot(int slot) {
        if (this.currentState == TileHeatExchangerTickAction.DecideRecipe.WAITING_FOR_RECIPE_MATCH) {
            return;
        }
        this.currentState = TileHeatExchangerTickAction.DecideRecipe.WAITING_INPUT_SLOT_CHANGE;
        LockableFluidTank tank = this.Tanks[slot];
        tank.setLockedType(false);
        tank.setFluid(null);
    }

    protected void setFluidFilter(int slot, FluidStack fluidStack) {
        if (this.currentState == TileHeatExchangerTickAction.DecideRecipe.WAITING_FOR_RECIPE_MATCH) {
            return;
        }
        this.currentState = TileHeatExchangerTickAction.DecideRecipe.MATCH_COOL_DOWN;
        LockableFluidTank tank = this.Tanks[slot];
        tank.setLockedType(true);
        tank.setFluid(new FluidStack(fluidStack, 0));
    }

    private int exchange(HeatExchangerEntry entry, ConvertDirection direction, LockableFluidTank input, LockableFluidTank output) {
        FluidStack In = entry.getInput(direction);
        FluidStack Out = entry.getOutput(direction);
        if (input.getFluidAmount() >= In.amount && output.getSpareVolume() >= Out.amount) {
            input.drainInternal(In, true);
            output.fillInternal(Out, true);
            return entry.HeatValue;
        }
        return 0;
    }

    protected void deltaIdle(int delta) {
        this.idleTime += delta;
        this.idleTime = MathHelper.func_76125_a((int)this.idleTime, (int)-200, (int)600);
    }

    public static class TileHeatExchangerTickAction {

        public static enum Processing implements ITickableStateMachine<AbstractTileHeatExchanger>
        {
            COOL_DOWN{

                @Override
                public ITickableStateMachine<AbstractTileHeatExchanger> nextState(AbstractTileHeatExchanger tickAble) {
                    if (--tickAble.coolDown <= 0) {
                        return DO_EXCHANGE;
                    }
                    return this;
                }
            }
            ,
            DO_EXCHANGE{

                @Override
                public ITickableStateMachine<AbstractTileHeatExchanger> nextState(AbstractTileHeatExchanger tickAble) {
                    if (++tickAble.tickSinceLastExchange > tickAble.tickRequired) {
                        tickAble.tickSinceLastExchange = 0;
                        tickAble.tickRequired = 0;
                        tickAble.deltaIdle(1);
                        HeatExchangerEntry ExchangeA = tickAble.cachedRecipe.ExchangeA;
                        HeatExchangerEntry ExchangeB = tickAble.cachedRecipe.ExchangeB;
                        ConvertDirection DirectionA = tickAble.cachedRecipe.DirectionA;
                        int oldHeat = tickAble.cachedHeat;
                        if (DirectionA == ConvertDirection.COOL_DOWN) {
                            if (tickAble.cachedHeat < ExchangeB.HeatValue) {
                                tickAble.cachedHeat += this.exchangeA(tickAble);
                            } else {
                                int doExchanged = this.exchangeB(tickAble);
                                tickAble.tickRequired = (int)((float)doExchanged * tickAble.Properties.getTickMultiplier());
                                tickAble.cachedHeat -= doExchanged;
                            }
                        } else if (tickAble.cachedHeat < ExchangeA.HeatValue) {
                            tickAble.cachedHeat += this.exchangeB(tickAble);
                        } else {
                            int doExchanged = this.exchangeA(tickAble);
                            tickAble.tickRequired = (int)((float)doExchanged * tickAble.Properties.getTickMultiplier());
                            tickAble.cachedHeat -= doExchanged;
                        }
                        if (oldHeat != tickAble.cachedHeat) {
                            tickAble.deltaIdle(-2);
                            return this;
                        }
                        tickAble.coolDown = tickAble.CoolDownBase + tickAble.idleTime;
                        return COOL_DOWN;
                    }
                    return this;
                }

                private int exchangeA(AbstractTileHeatExchanger tickAble) {
                    return tickAble.exchange(tickAble.cachedRecipe.ExchangeA, tickAble.cachedRecipe.DirectionA, tickAble.Tanks[0], tickAble.Tanks[1]);
                }

                private int exchangeB(AbstractTileHeatExchanger tickAble) {
                    return tickAble.exchange(tickAble.cachedRecipe.ExchangeB, tickAble.cachedRecipe.DirectionB, tickAble.Tanks[2], tickAble.Tanks[3]);
                }
            };

        }

        public static enum DecideRecipe implements ITickableStateMachine<AbstractTileHeatExchanger>
        {
            WAITING_INPUT_SLOT_CHANGE,
            MATCH_COOL_DOWN{

                @Override
                public ITickableStateMachine<AbstractTileHeatExchanger> nextState(AbstractTileHeatExchanger tickAble) {
                    if (--tickAble.coolDown <= 0) {
                        return IS_INPUT_READY_FOR_MATCH;
                    }
                    return this;
                }
            }
            ,
            IS_INPUT_READY_FOR_MATCH{

                @Override
                public ITickableStateMachine<AbstractTileHeatExchanger> nextState(AbstractTileHeatExchanger tickAble) {
                    if (tickAble.Tanks[0].getFluid() != null && tickAble.Tanks[2].getFluid() != null) {
                        try {
                            HeatExchangerRegistry.REGISTRY.RecipeFinder.submit(() -> {
                                tickAble.cachedRecipe = HeatExchangerRegistry.REGISTRY.findRecipe((IFluidTank)tickAble.Tanks[0], (IFluidTank)tickAble.Tanks[2], (IFluidTank)tickAble.Tanks[1], (IFluidTank)tickAble.Tanks[3]).orElse(null);
                            }).get(20L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException e) {
                            ImmersiveChemicalEngineering.logger.error("Exception occurred while searching recipes", (Throwable)e);
                            tickAble.cachedRecipe = null;
                        }
                        finally {
                            ApiUtils.addFutureServerTask((World)tickAble.field_145850_b, () -> {
                                tickAble.currentState = tickAble.cachedRecipe != null ? Processing.DO_EXCHANGE : WAITING_INPUT_SLOT_CHANGE;
                            });
                        }
                        return WAITING_FOR_RECIPE_MATCH;
                    }
                    return WAITING_INPUT_SLOT_CHANGE;
                }
            }
            ,
            WAITING_FOR_RECIPE_MATCH;

        }
    }
}

