/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.tileentity;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import team.cappcraft.immersivechemical.common.tileentity.ILockableSlot;

public class LockableFluidTank
extends FluidTank
implements ILockableSlot {
    public static final String TAG_LOCKED = "Locked";
    public static final String TAG_LOCKED_TYPE = "LockedType";
    private final Consumer<FluidEvent> onContentChangedConsumer;
    private boolean locked = false;
    private boolean lockedType = false;

    public LockableFluidTank(int capacity, Consumer<FluidEvent> onContentChanged) {
        super(capacity);
        this.onContentChangedConsumer = onContentChanged;
    }

    public LockableFluidTank(@Nullable FluidStack fluidStack, int capacity, Consumer<FluidEvent> onContentChanged) {
        super(fluidStack, capacity);
        this.onContentChangedConsumer = onContentChanged;
    }

    public LockableFluidTank(Fluid fluid, int amount, int capacity, Consumer<FluidEvent> onContentChanged) {
        super(fluid, amount, capacity);
        this.onContentChangedConsumer = onContentChanged;
    }

    public int getSpareVolume() {
        if (this.fluid != null) {
            return this.capacity - this.fluid.amount;
        }
        return this.capacity;
    }

    public boolean canDrain() {
        return !this.isLocked() && super.canDrain();
    }

    public boolean canFill() {
        return !this.isLocked() && super.canFill();
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        this.locked = nbt.func_74767_n(TAG_LOCKED);
        this.lockedType = nbt.func_74767_n(TAG_LOCKED_TYPE);
        return super.readFromNBT(nbt);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a(TAG_LOCKED, this.locked);
        nbt.func_74757_a(TAG_LOCKED_TYPE, this.lockedType);
        return super.writeToNBT(nbt);
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0 || this.fluid == null && this.isLockedType()) {
            return 0;
        }
        if (!doFill) {
            if (this.fluid == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.amount, resource.amount);
        }
        if (this.fluid == null) {
            this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.amount));
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.FluidFillingEvent fluidEvent = new FluidEvent.FluidFillingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, this.fluid.amount);
                this.onContentChangedConsumer.accept((FluidEvent)fluidEvent);
                FluidEvent.fireEvent((FluidEvent)fluidEvent);
            }
            return this.fluid.amount;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.amount;
        if (resource.amount < filled) {
            this.fluid.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluid.amount = this.capacity;
        }
        this.onContentsChanged();
        if (this.tile != null) {
            FluidEvent.FluidFillingEvent fluidEvent = new FluidEvent.FluidFillingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, filled);
            this.onContentChangedConsumer.accept((FluidEvent)fluidEvent);
            FluidEvent.fireEvent((FluidEvent)fluidEvent);
        }
        return filled;
    }

    @Nullable
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        if (this.fluid == null || maxDrain <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluid.amount < drained) {
            drained = this.fluid.amount;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (doDrain) {
            this.fluid.amount -= drained;
            if (this.fluid.amount <= 0 && !this.isLockedType()) {
                this.fluid = null;
            }
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.FluidDrainingEvent fluidEvent = new FluidEvent.FluidDrainingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, drained);
                this.onContentChangedConsumer.accept((FluidEvent)fluidEvent);
                FluidEvent.fireEvent((FluidEvent)fluidEvent);
            }
        }
        return stack;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
        if (!locked && this.fluid != null && this.fluid.amount <= 0) {
            this.fluid = null;
        }
        if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }

    @Override
    public boolean isLockedType() {
        return this.lockedType;
    }

    @Override
    public void setLockedType(boolean locked) {
        this.lockedType = locked;
        if (!locked && this.fluid != null && this.fluid.amount <= 0) {
            this.fluid = null;
        }
        if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }
}

