/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.tileentity;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import team.cappcraft.immersivechemical.common.tileentity.AbstractTileHeatExchanger;
import team.cappcraft.immersivechemical.common.tileentity.LockableFluidTank;
import team.cappcraft.immersivechemical.common.tileentity.constant.HeatExchangerSizeVariants;

public class TileHeatExchangerMedium
extends AbstractTileHeatExchanger {
    protected static final int FluidAccessPointInputA = 15;
    protected static final int FluidAccessPointOutputA = 0;
    protected static final int FluidAccessPointInputB = 6;
    protected static final int FluidAccessPointOutputB = 11;
    protected static final int ComparatorAccessPointInputA = 5;
    protected static final int ComparatorAccessPointOutputA = 6;
    protected static final int ComparatorAccessPointInputB = 0;
    protected static final int ComparatorAccessPointOutputB = 1;

    public TileHeatExchangerMedium() {
        super(new int[]{2, 2, 5}, HeatExchangerSizeVariants.MEDIUM);
    }

    @Override
    protected void onInputSlotChanged(FluidEvent event) {
        super.onInputSlotChanged(event);
        this.markBlockForUpdate(this.getBlockPosForPos(5), null);
        this.markBlockForUpdate(this.getBlockPosForPos(0), null);
    }

    @Override
    protected void onOutputSlotChanged(FluidEvent event) {
        super.onOutputSlotChanged(event);
        this.markBlockForUpdate(this.getBlockPosForPos(6), null);
        this.markBlockForUpdate(this.getBlockPosForPos(1), null);
    }

    @Override
    protected void clearFluidSlot(int slot) {
        super.clearFluidSlot(slot);
        switch (slot) {
            case 0: {
                this.markBlockForUpdate(this.getBlockPosForPos(5), null);
                break;
            }
            case 1: {
                this.markBlockForUpdate(this.getBlockPosForPos(6), null);
                break;
            }
            case 2: {
                this.markBlockForUpdate(this.getBlockPosForPos(0), null);
                break;
            }
            case 3: {
                this.markBlockForUpdate(this.getBlockPosForPos(1), null);
            }
        }
    }

    @Override
    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(@Nonnull EnumFacing side) {
        AbstractTileHeatExchanger master;
        if (side.func_176740_k() == EnumFacing.Axis.Y && (master = (AbstractTileHeatExchanger)this.master()) != null) {
            switch (this.field_174879_c) {
                case 15: {
                    if (side == EnumFacing.UP) {
                        return new IFluidTank[]{master.Tanks[0]};
                    }
                }
                case 0: {
                    if (side == EnumFacing.DOWN) {
                        return new IFluidTank[]{master.Tanks[1]};
                    }
                }
                case 6: {
                    if (side == EnumFacing.DOWN) {
                        return new IFluidTank[]{master.Tanks[2]};
                    }
                }
                case 11: {
                    if (side != EnumFacing.UP) break;
                    return new IFluidTank[]{master.Tanks[3]};
                }
            }
        }
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, @Nonnull EnumFacing side, @Nonnull FluidStack resource) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            switch (this.field_174879_c) {
                case 15: {
                    return side == EnumFacing.UP;
                }
                case 6: {
                    return side == EnumFacing.DOWN;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, @Nonnull EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            switch (this.field_174879_c) {
                case 0: {
                    return side == EnumFacing.DOWN;
                }
                case 11: {
                    return side == EnumFacing.UP;
                }
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack getOriginalBlock() {
        if (this.field_174879_c % 5 == 0) {
            return new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.RADIATOR.getMeta());
        }
        return new ItemStack((Block)IEContent.blockSheetmetal, 1, BlockTypes_MetalsAll.IRON.getMeta());
    }

    @Override
    @Nonnull
    public float[] getBlockBounds() {
        int h = this.field_174879_c / 10;
        int l = this.field_174879_c % 10 / 5;
        int w = this.field_174879_c % 5;
        if (w == 0) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        boolean Front = l == (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0 : 1);
        float X_1 = Front ? 0.09f : 0.0f;
        float X_2 = !Front ? 0.91f : 1.0f;
        float Y_1 = 0.0f;
        float Y_2 = 1.0f;
        float Z_1 = 0.0f;
        float Z_2 = 1.0f;
        if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
            return new float[]{X_1, 0.0f, 0.0f, X_2, 1.0f, 1.0f};
        }
        return new float[]{0.0f, 0.0f, X_1, 1.0f, 1.0f, X_2};
    }

    public int getComparatorInputOverride() {
        AbstractTileHeatExchanger master = (AbstractTileHeatExchanger)this.master();
        if (master == null) {
            return 0;
        }
        LockableFluidTank[] Tanks = master.Tanks;
        switch (this.field_174879_c) {
            case 5: {
                return 15 * Tanks[0].getFluidAmount() / Tanks[0].getCapacity();
            }
            case 6: {
                return 15 * Tanks[1].getFluidAmount() / Tanks[1].getCapacity();
            }
            case 0: {
                return 15 * Tanks[2].getFluidAmount() / Tanks[2].getCapacity();
            }
            case 1: {
                return 15 * Tanks[3].getFluidAmount() / Tanks[3].getCapacity();
            }
        }
        return 0;
    }
}

