/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.tileentity;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import team.cappcraft.immersivechemical.common.tileentity.AbstractTileHeatExchanger;
import team.cappcraft.immersivechemical.common.tileentity.LockableFluidTank;
import team.cappcraft.immersivechemical.common.tileentity.constant.HeatExchangerSizeVariants;

public class TileHeatExchangerSmall
extends AbstractTileHeatExchanger {
    protected static final int FluidAccessPointA = 0;
    protected static final int FluidAccessPointB = 3;
    protected static final int ComparatorAccessPointInputA = 0;
    protected static final int ComparatorAccessPointOutputA = 1;
    protected static final int ComparatorAccessPointInputB = 3;
    protected static final int ComparatorAccessPointOutputB = 2;

    public TileHeatExchangerSmall() {
        super(new int[]{1, 1, 4}, HeatExchangerSizeVariants.SMALL);
    }

    @Override
    protected void onInputSlotChanged(FluidEvent event) {
        super.onInputSlotChanged(event);
        this.markBlockForUpdate(this.getBlockPosForPos(0), null);
        this.markBlockForUpdate(this.getBlockPosForPos(3), null);
    }

    @Override
    protected void onOutputSlotChanged(FluidEvent event) {
        super.onOutputSlotChanged(event);
        this.markBlockForUpdate(this.getBlockPosForPos(1), null);
        this.markBlockForUpdate(this.getBlockPosForPos(2), null);
    }

    @Override
    protected void clearFluidSlot(int slot) {
        super.clearFluidSlot(slot);
        switch (slot) {
            case 0: {
                this.markBlockForUpdate(this.getBlockPosForPos(0), null);
                break;
            }
            case 1: {
                this.markBlockForUpdate(this.getBlockPosForPos(1), null);
                break;
            }
            case 2: {
                this.markBlockForUpdate(this.getBlockPosForPos(3), null);
                break;
            }
            case 3: {
                this.markBlockForUpdate(this.getBlockPosForPos(2), null);
            }
        }
    }

    @Override
    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(@Nonnull EnumFacing side) {
        AbstractTileHeatExchanger master;
        if (side.func_176740_k() == EnumFacing.Axis.Y && (master = (AbstractTileHeatExchanger)this.master()) != null) {
            switch (this.field_174879_c) {
                case 0: {
                    return new IFluidTank[]{side == EnumFacing.UP ? master.Tanks[0] : master.Tanks[1]};
                }
                case 3: {
                    return new IFluidTank[]{side == EnumFacing.UP ? master.Tanks[2] : master.Tanks[3]};
                }
            }
        }
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, @Nonnull EnumFacing side, @Nonnull FluidStack resource) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            switch (this.field_174879_c) {
                case 0: 
                case 3: {
                    return side == EnumFacing.UP;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, @Nonnull EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            switch (this.field_174879_c) {
                case 0: 
                case 3: {
                    return side == EnumFacing.DOWN;
                }
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack getOriginalBlock() {
        switch (this.field_174879_c) {
            case 0: 
            case 3: {
                return new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.RADIATOR.getMeta());
            }
        }
        return new ItemStack((Block)IEContent.blockSheetmetal, 1, BlockTypes_MetalsAll.IRON.getMeta());
    }

    @Override
    @Nonnull
    public float[] getBlockBounds() {
        switch (this.field_174879_c) {
            case 0: 
            case 3: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            }
        }
        if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
            return new float[]{0.1f, 0.0f, 0.0f, 0.9f, 1.0f, 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.1f, 1.0f, 1.0f, 0.9f};
    }

    public int getComparatorInputOverride() {
        AbstractTileHeatExchanger master = (AbstractTileHeatExchanger)this.master();
        if (master == null) {
            return 0;
        }
        LockableFluidTank[] Tanks = master.Tanks;
        switch (this.field_174879_c) {
            case 0: {
                return 15 * Tanks[0].getFluidAmount() / Tanks[0].getCapacity();
            }
            case 1: {
                return 15 * Tanks[1].getFluidAmount() / Tanks[1].getCapacity();
            }
            case 3: {
                return 15 * Tanks[2].getFluidAmount() / Tanks[2].getCapacity();
            }
            case 2: {
                return 15 * Tanks[3].getFluidAmount() / Tanks[3].getCapacity();
            }
        }
        return 0;
    }
}

