/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.immersivechemical.common.util;

public class MathHelper {
    public static int LeastCommonMultiple(int valA, int valB) {
        if (valA < 0 || valB < 0) {
            throw new ArithmeticException("Only Natural number has factor");
        }
        if (valA == 0 || valB == 0) {
            throw new ArithmeticException("Zero has no factor");
        }
        return valA * valB / MathHelper.GreatestCommonDivisor(valA, valB);
    }

    public static int GreatestCommonDivisor(int valA, int valB) {
        if (valA < 0 || valB < 0) {
            throw new ArithmeticException("Only Natural number has factor");
        }
        if (valA == 0 || valB == 0) {
            return Math.max(valA, valB);
        }
        if (valA % valB == 0) {
            return valB;
        }
        return MathHelper.GreatestCommonDivisor(valB, valA % valB);
    }

    public static int ReduceRemainder(int dividend, int divisor) {
        return dividend - dividend % divisor;
    }
}

