/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.jgrapht.alg.interfaces;

import team.cappcraft.jgrapht.Graph;

public interface AStarAdmissibleHeuristic<V> {
    public double getCostEstimate(V var1, V var2);

    default public <E> boolean isConsistent(Graph<V, E> graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph cannot be null!");
        }
        for (V targetVertex : graph.vertexSet()) {
            for (E e : graph.edgeSet()) {
                double h_y;
                double weight = graph.getEdgeWeight(e);
                V edgeSource = graph.getEdgeSource(e);
                V edgeTarget = graph.getEdgeTarget(e);
                double h_x = this.getCostEstimate(edgeSource, targetVertex);
                if (!(h_x > weight + (h_y = this.getCostEstimate(edgeTarget, targetVertex)))) continue;
                return false;
            }
        }
        return true;
    }
}

