/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.jgrapht.alg.isomorphism;

import java.util.Comparator;
import team.cappcraft.jgrapht.alg.isomorphism.GraphOrdering;
import team.cappcraft.jgrapht.alg.isomorphism.VF2State;

class VF2SubgraphIsomorphismState<V, E>
extends VF2State<V, E> {
    public VF2SubgraphIsomorphismState(GraphOrdering<V, E> g1, GraphOrdering<V, E> g2, Comparator<V> vertexComparator, Comparator<E> edgeComparator) {
        super(g1, g2, vertexComparator, edgeComparator);
    }

    public VF2SubgraphIsomorphismState(VF2State<V, E> s) {
        super(s);
    }

    @Override
    public boolean isFeasiblePair() {
        int other1;
        int other2;
        String pairstr = "(" + this.g1.getVertex(this.addVertex1) + ", " + this.g2.getVertex(this.addVertex2) + ")";
        String abortmsg = pairstr + " does not fit in the current matching";
        if (!this.areCompatibleVertexes(this.addVertex1, this.addVertex2)) {
            return false;
        }
        int termOutPred1 = 0;
        int termOutPred2 = 0;
        int termInPred1 = 0;
        int termInPred2 = 0;
        int newPred1 = 0;
        int newPred2 = 0;
        int termOutSucc1 = 0;
        int termOutSucc2 = 0;
        int termInSucc1 = 0;
        int termInSucc2 = 0;
        int newSucc1 = 0;
        int newSucc2 = 0;
        for (int other12 : this.g1.getOutEdges(this.addVertex1)) {
            if (this.core1[other12] != -1) {
                other2 = this.core1[other12];
                if (this.g2.hasEdge(this.addVertex2, other2) && this.areCompatibleEdges(this.addVertex1, other12, this.addVertex2, other2)) continue;
                this.showLog("isFeasiblePair", abortmsg + ": edge from " + this.g2.getVertex(this.addVertex2) + " to " + this.g2.getVertex(other2) + " is missing in the 2nd graph");
                return false;
            }
            if (this.in1[other12] > 0) {
                ++termInSucc1;
            }
            if (this.out1[other12] > 0) {
                ++termOutSucc1;
            }
            if (this.in1[other12] != 0 || this.out1[other12] != 0) continue;
            ++newSucc1;
        }
        for (int other22 : this.g2.getOutEdges(this.addVertex2)) {
            if (this.core2[other22] != -1) {
                other1 = this.core2[other22];
                if (this.g1.hasEdge(this.addVertex1, other1)) continue;
                this.showLog("isFeasbilePair", abortmsg + ": edge from " + this.g1.getVertex(this.addVertex1) + " to " + this.g1.getVertex(other1) + " is missing in the 1st graph");
                return false;
            }
            if (this.in2[other22] > 0) {
                ++termInSucc2;
            }
            if (this.out2[other22] > 0) {
                ++termOutSucc2;
            }
            if (this.in2[other22] != 0 || this.out2[other22] != 0) continue;
            ++newSucc2;
        }
        if (termInSucc1 < termInSucc2 || termOutSucc1 < termOutSucc2 || newSucc1 < newSucc2) {
            return false;
        }
        for (int other12 : this.g1.getInEdges(this.addVertex1)) {
            if (this.core1[other12] != -1) {
                other2 = this.core1[other12];
                if (this.g2.hasEdge(other2, this.addVertex2) && this.areCompatibleEdges(other12, this.addVertex1, other2, this.addVertex2)) continue;
                this.showLog("isFeasbilePair", abortmsg + ": edge from " + this.g2.getVertex(other2) + " to " + this.g2.getVertex(this.addVertex2) + " is missing in the 2nd graph");
                return false;
            }
            if (this.in1[other12] > 0) {
                ++termInPred1;
            }
            if (this.out1[other12] > 0) {
                ++termOutPred1;
            }
            if (this.in1[other12] != 0 || this.out1[other12] != 0) continue;
            ++newPred1;
        }
        for (int other22 : this.g2.getInEdges(this.addVertex2)) {
            if (this.core2[other22] != -1) {
                other1 = this.core2[other22];
                if (this.g1.hasEdge(other1, this.addVertex1)) continue;
                this.showLog("isFeasiblePair", abortmsg + ": edge from " + this.g1.getVertex(other1) + " to " + this.g1.getVertex(this.addVertex1) + " is missing in the 1st graph");
                return false;
            }
            if (this.in2[other22] > 0) {
                ++termInPred2;
            }
            if (this.out2[other22] > 0) {
                ++termOutPred2;
            }
            if (this.in2[other22] != 0 || this.out2[other22] != 0) continue;
            ++newPred2;
        }
        if (termInPred1 >= termInPred2 && termOutPred1 >= termOutPred2 && newPred1 >= newPred2) {
            this.showLog("isFeasiblePair", pairstr + " fits");
            return true;
        }
        return false;
    }
}

