/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.jgrapht.alg.shortestpath;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import team.cappcraft.jgrapht.Graph;
import team.cappcraft.jgrapht.Graphs;
import team.cappcraft.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import team.cappcraft.jgrapht.alg.shortestpath.TreeSingleSourcePathsImpl;
import team.cappcraft.jgrapht.alg.util.Pair;
import team.cappcraft.jheaps.AddressableHeap;
import team.cappcraft.jheaps.tree.PairingHeap;

class DijkstraClosestFirstIterator<V, E>
implements Iterator<V> {
    private final Graph<V, E> graph;
    private final V source;
    private final double radius;
    private final Map<V, AddressableHeap.Handle<Double, Pair<V, E>>> seen;
    private AddressableHeap<Double, Pair<V, E>> heap;

    public DijkstraClosestFirstIterator(Graph<V, E> graph, V source) {
        this(graph, source, Double.POSITIVE_INFINITY, PairingHeap::new);
    }

    public DijkstraClosestFirstIterator(Graph<V, E> graph, V source, double radius) {
        this(graph, source, radius, PairingHeap::new);
    }

    public DijkstraClosestFirstIterator(Graph<V, E> graph, V source, Supplier<AddressableHeap<Double, Pair<V, E>>> heapSupplier) {
        this(graph, source, Double.POSITIVE_INFINITY, heapSupplier);
    }

    public DijkstraClosestFirstIterator(Graph<V, E> graph, V source, double radius, Supplier<AddressableHeap<Double, Pair<V, E>>> heapSupplier) {
        this.graph = Objects.requireNonNull(graph, "Graph cannot be null");
        this.source = Objects.requireNonNull(source, "Source vertex cannot be null");
        Objects.requireNonNull(heapSupplier, "Heap supplier cannot be null");
        if (radius < 0.0) {
            throw new IllegalArgumentException("Radius must be non-negative");
        }
        this.radius = radius;
        this.seen = new HashMap<V, AddressableHeap.Handle<Double, Pair<V, E>>>();
        this.heap = heapSupplier.get();
        this.updateDistance(source, null, 0.0);
    }

    @Override
    public boolean hasNext() {
        if (this.heap.isEmpty()) {
            return false;
        }
        AddressableHeap.Handle<Double, Pair<V, E>> vNode = this.heap.findMin();
        double vDistance = vNode.getKey();
        if (this.radius < vDistance) {
            this.heap.clear();
            return false;
        }
        return true;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        AddressableHeap.Handle<Double, Pair<V, E>> vNode = this.heap.deleteMin();
        V v = vNode.getValue().getFirst();
        double vDistance = vNode.getKey();
        for (E e : this.graph.outgoingEdgesOf(v)) {
            V u = Graphs.getOppositeVertex(this.graph, e, v);
            double eWeight = this.graph.getEdgeWeight(e);
            if (eWeight < 0.0) {
                throw new IllegalArgumentException("Negative edge weight not allowed");
            }
            this.updateDistance(u, e, vDistance + eWeight);
        }
        return v;
    }

    public ShortestPathAlgorithm.SingleSourcePaths<V, E> getPaths() {
        return new TreeSingleSourcePathsImpl<V, E>(this.graph, this.source, this.getDistanceAndPredecessorMap());
    }

    public Map<V, Pair<Double, E>> getDistanceAndPredecessorMap() {
        HashMap<V, Pair<Double, E>> distanceAndPredecessorMap = new HashMap<V, Pair<Double, E>>();
        for (AddressableHeap.Handle<Double, Pair<V, E>> vNode : this.seen.values()) {
            double vDistance = vNode.getKey();
            if (this.radius < vDistance) continue;
            V v = vNode.getValue().getFirst();
            distanceAndPredecessorMap.put(v, Pair.of(vDistance, vNode.getValue().getSecond()));
        }
        return distanceAndPredecessorMap;
    }

    private void updateDistance(V v, E e, double distance) {
        AddressableHeap.Handle<Double, Pair<Pair<V, E>, E>> node = this.seen.get(v);
        if (node == null) {
            node = this.heap.insert(distance, Pair.of(v, e));
            this.seen.put((AddressableHeap.Handle<Double, Pair<Pair<V, E>, E>>)v, (AddressableHeap.Handle<Double, Pair<AddressableHeap.Handle<Double, Pair<Pair<V, E>, E>>, E>>)node);
        } else if (distance < node.getKey()) {
            node.decreaseKey(distance);
            node.setValue(Pair.of(node.getValue().getFirst(), e));
        }
    }
}

