/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.jgrapht.graph;

import java.util.function.Supplier;
import team.cappcraft.jgrapht.graph.AbstractBaseGraph;
import team.cappcraft.jgrapht.graph.DefaultGraphType;
import team.cappcraft.jgrapht.graph.builder.GraphBuilder;
import team.cappcraft.jgrapht.util.SupplierUtil;

public class DefaultDirectedGraph<V, E>
extends AbstractBaseGraph<V, E> {
    private static final long serialVersionUID = -2066644490824847621L;

    public DefaultDirectedGraph(Class<? extends E> edgeClass) {
        this(null, SupplierUtil.createSupplier(edgeClass), false);
    }

    public DefaultDirectedGraph(Supplier<V> vertexSupplier, Supplier<E> edgeSupplier, boolean weighted) {
        super(vertexSupplier, edgeSupplier, new DefaultGraphType.Builder().directed().allowMultipleEdges(false).allowSelfLoops(true).weighted(weighted).build());
    }

    public static <V, E> GraphBuilder<V, E, ? extends DefaultDirectedGraph<V, E>> createBuilder(Class<? extends E> edgeClass) {
        return new GraphBuilder(new DefaultDirectedGraph<V, E>(edgeClass));
    }

    public static <V, E> GraphBuilder<V, E, ? extends DefaultDirectedGraph<V, E>> createBuilder(Supplier<E> edgeSupplier) {
        return new GraphBuilder(new DefaultDirectedGraph<V, E>(null, edgeSupplier, false));
    }
}

