/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.jgrapht.graph;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import team.cappcraft.jgrapht.Graph;
import team.cappcraft.jgrapht.GraphType;
import team.cappcraft.jgrapht.graph.GraphSpecificsStrategy;
import team.cappcraft.jgrapht.graph.IntrusiveEdgesSpecifics;
import team.cappcraft.jgrapht.graph.UniformIntrusiveEdgesSpecifics;
import team.cappcraft.jgrapht.graph.WeightedIntrusiveEdgesSpecifics;
import team.cappcraft.jgrapht.graph.specifics.DirectedSpecifics;
import team.cappcraft.jgrapht.graph.specifics.Specifics;
import team.cappcraft.jgrapht.graph.specifics.UndirectedSpecifics;

public class DefaultGraphSpecificsStrategy<V, E>
implements GraphSpecificsStrategy<V, E> {
    private static final long serialVersionUID = 7615319421753562075L;

    @Override
    public Function<GraphType, IntrusiveEdgesSpecifics<V, E>> getIntrusiveEdgesSpecificsFactory() {
        return (Function<GraphType, IntrusiveEdgesSpecifics> & Serializable)type -> {
            if (type.isWeighted()) {
                return new WeightedIntrusiveEdgesSpecifics(new LinkedHashMap());
            }
            return new UniformIntrusiveEdgesSpecifics(new LinkedHashMap());
        };
    }

    @Override
    public BiFunction<Graph<V, E>, GraphType, Specifics<V, E>> getSpecificsFactory() {
        return (BiFunction<Graph, GraphType, Specifics> & Serializable)(graph, type) -> {
            if (type.isDirected()) {
                return new DirectedSpecifics(graph, new LinkedHashMap(), this.getEdgeSetFactory());
            }
            return new UndirectedSpecifics(graph, new LinkedHashMap(), this.getEdgeSetFactory());
        };
    }
}

