/*
 * Decompiled with CFR 0.152.
 */
package team.cappcraft.jgrapht.graph;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import team.cappcraft.jgrapht.Graph;
import team.cappcraft.jgrapht.GraphType;
import team.cappcraft.jgrapht.graph.GraphSpecificsStrategy;
import team.cappcraft.jgrapht.graph.IntrusiveEdgesSpecifics;
import team.cappcraft.jgrapht.graph.UniformIntrusiveEdgesSpecifics;
import team.cappcraft.jgrapht.graph.WeightedIntrusiveEdgesSpecifics;
import team.cappcraft.jgrapht.graph.specifics.FastLookupDirectedSpecifics;
import team.cappcraft.jgrapht.graph.specifics.FastLookupUndirectedSpecifics;
import team.cappcraft.jgrapht.graph.specifics.Specifics;

public class FastLookupGraphSpecificsStrategy<V, E>
implements GraphSpecificsStrategy<V, E> {
    private static final long serialVersionUID = -5490869870275054280L;

    @Override
    public Function<GraphType, IntrusiveEdgesSpecifics<V, E>> getIntrusiveEdgesSpecificsFactory() {
        return (Function<GraphType, IntrusiveEdgesSpecifics> & Serializable)type -> {
            if (type.isWeighted()) {
                return new WeightedIntrusiveEdgesSpecifics(new LinkedHashMap());
            }
            return new UniformIntrusiveEdgesSpecifics(new LinkedHashMap());
        };
    }

    @Override
    public BiFunction<Graph<V, E>, GraphType, Specifics<V, E>> getSpecificsFactory() {
        return (BiFunction<Graph, GraphType, Specifics> & Serializable)(graph, type) -> {
            if (type.isDirected()) {
                return new FastLookupDirectedSpecifics(graph, new LinkedHashMap(), new HashMap(), this.getEdgeSetFactory());
            }
            return new FastLookupUndirectedSpecifics(graph, new LinkedHashMap(), new HashMap(), this.getEdgeSetFactory());
        };
    }
}

